<!DOCTYPE html>
    <html lang="en-US" data-theme="light" data-ref="home" class=" page-optimization-more-content" data-url-locale="" data-locale="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>HoneyToon: Discover Unlimited Comics Across Genres</title>
    <meta name="description" content="Explore the newest comics on Honeytoon! Enjoy romance, adventure, and drama in stunning webtoons. Dive in now and start reading your next favorite story!">
    <link rel="canonical" href="comic/the-head-of-a-womens-association.html" />

                        <meta property="og:title" content="HoneyToon: Discover Unlimited Comics Across Genres">

    <meta property="og:description" content="Explore the newest comics on Honeytoon! Enjoy romance, adventure, and drama in stunning webtoons. Dive in now and start reading your next favorite story!">
    <meta name="twitter:description" content="Explore the newest comics on Honeytoon! Enjoy romance, adventure, and drama in stunning webtoons. Dive in now and start reading your next favorite story!">

<meta property="og:site_name" content="Honeytoon">
<meta property="og:type" content="website">
<meta property="og:url" content="https://honeytoon.com/">

<meta name="twitter:card" content="summary_large_image">
<meta property="twitter:domain" content="https://honeytoon.com/">

    <meta property="og:image" content="https://honeytoon.com/build/images/favicon/og.svg">
    <meta name="twitter:image" content="https://honeytoon.com/build/images/favicon/og.svg">
            <script type="application/ld+json">
            {
                "@context": "https://schema.org",
                "@type": "Organization",
                "name": "HoneyToon",
                "alternateName": "honeytoon.com",
                "url": "https://honeytoon.com/",
                "logo": "https://honeytoon.com/build/images/logo/logo.svg?t=9723654",
                "sameAs": [
                    "https://www.facebook.com/honeytoon.en",
                    "https://www.instagram.com/honeytoon_comics?igsh=anpidXhscnowdDIx",
                    "https://x.com/Honeytoon_en",
                    "https://www.tiktok.com/@honeytoon_co"
                ]
            }
        </script>
    
    
                        <link rel="alternate" hreflang="en" href="comic/the-head-of-a-womens-association.html" />
                    <link rel="alternate" hreflang="fr" href="fr.html" />
                    <link rel="alternate" hreflang="de" href="de.html" />
                    <link rel="alternate" hreflang="es" href="es.html" />
                    <link rel="alternate" hreflang="pt" href="pt.html" />
                    <link rel="alternate" hreflang="it" href="it.html" />
                        <link rel="alternate" hreflang="x-default" href="comic/the-head-of-a-womens-association.html" />
    
    <link rel="apple-touch-icon" sizes="180x180" href="build/images/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="build/images/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="build/images/favicon/favicon-16x16.png">
    <link rel="manifest" href="build/images/favicon/site.webmanifest">
    <link rel="mask-icon" href="build/images/favicon/safari-pinned-tab.svg" color="#1a1817">
    <meta name="msapplication-TileColor" content="#00aba9">
    <meta name="theme-color" content="#1A1817">

    
    <script>
        const sign_up_in_text = {
            invalid_email: 'Invalid email address',
            incorrect_password: 'Your password is incorrect. Please use a different one',
        }
    </script>

    <script>
        const GLOBAL_USER_ID = 6413757;
        const GLOBAL_ENV = "prod";
        const SENTRY_DSN = "https://5b476cd980bdbcdfb59489daab864456@sentry.honeytoon.com/11";

        const INTERCOM_API_BASE = "https://api-iam.intercom.io"
        const INTERCOM_APP_ID = "q38a2z9o"
        const INTERCOM_WEBSITE = "https://honeytoon.com/"
        const INTERCOM_USER_HASH = "f5114cbcefafb1d6a4fdfcff47c576418de5670a9f61fb9c67d46eeca4b91f3d"
        const INTERCOM_USER_ID = "6413757"
        const INTERCOM_USER_EMAIl = "seedmnawi109@gmail.com"
        const INTERCOM_USER_CREATED_AT = "1738935756"

        const INTERCOM_SETTINGS = {
            api_base: INTERCOM_API_BASE,
            app_id: INTERCOM_APP_ID,
            user_id: INTERCOM_USER_ID,
            email: INTERCOM_USER_EMAIl,
            created_at: INTERCOM_USER_CREATED_AT,
            user_hash: INTERCOM_USER_HASH,
        }
    </script>

    <script>
        const LOCALE = 'en'
        const IS_HONEYTOON = 1
        const IS_HONEYTOONS = 0
        const IS_TT_BR = 0
        const IS_TT_DEBUG = 0

                const UNC_UPSELL_TYPE = 'upgrade'
        
        const IS_UNCENSORED_AVAILABLE = 1
        const PAGE_REFERRER = ''
        const EXPERIMENT = '{"75":"b","104":"a","128":"b","129":"a","130":"a","152":"b","153":"b"}'
        const HAS_SUBSCRIPTION = 1
    </script>

    
    
    
            <script>(function () {window.oncontextmenu = function () {return false;}}())</script>
    
                <link rel="stylesheet" href="build/921.a6e0766b.css">
            <link rel="stylesheet" href="build/homepage.8027b12c.css">
    
    





    <!-- Reddit Pixel -->
    <script>
        !function (w, d) {
            if (!w.rdt) {
                var p = w.rdt = function () {
                    p.sendEvent ? p.sendEvent.apply(p, arguments) : p.callQueue.push(arguments)
                };
                p.callQueue = [];
                var t = d.createElement("script");
                t.src = "https://www.redditstatic.com/ads/pixel.js", t.async = !0;
                var s = d.getElementsByTagName("script")[0];
                s.parentNode.insertBefore(t, s)
            }
        }(window, document);
                rdt('init', 'a2_fg5ct0evr63d', {
            email: 'seedmnawi109@gmail.com',
            externalId: '6413757',
        });
        rdt('init', 'a2_gnmfb1ghy37u', {
            email: 'seedmnawi109@gmail.com',
            externalId: '6413757',
        });
        rdt('init', 'a2_ff7xgldc1q5k', {
            email: 'seedmnawi109@gmail.com',
            externalId: '6413757',
        });
                rdt('track', 'PageVisit');
    </script>
    <!-- DO NOT MODIFY UNLESS TO REPLACE A USER IDENTIFIER -->
    <!-- End Reddit Pixel -->

    <!-- Twitter conversion tracking base code -->
    <script>
        !function(e,t,n,s,u,a){e.twq||(s=e.twq=function(){s.exe?s.exe.apply(s,arguments):s.queue.push(arguments);
        },s.version='1.1',s.queue=[],u=t.createElement(n),u.async=!0,u.src='https://static.ads-twitter.com/uwt.js',
            a=t.getElementsByTagName(n)[0],a.parentNode.insertBefore(u,a))}(window,document,'script');
        twq('config','omuuy');
        twq('config','onc8x');

                twq('config','onjvo');
        twq('config','onjvr');
        
                twq('config','onl9s');
                twq('config','pbidu');
        twq('config','pdnar');
        twq('config','pdndi');
        twq('config','pdljv');
        twq('config','pbjd5');
        twq('config','pl9ez');
    </script>
    <!-- End Twitter conversion tracking base code -->




<script>

    
    
    class fbca {

        
        PageView() {

            let event_id = this.getCookie('request_id') + '1';

            try {
                console.log('%c PageView ' + event_id + ' ', 'background: #222; color: #bada55');
                window.logOnDB(event_id, 'PageView')

                let formData = new FormData();
                formData.append('locale', 'en');
                formData.append('event_id', event_id);
                formData.append('event_name', 'PageView');
                formData.append('tiktok_event_name', 'PageView');
                formData.append('snap_event_name', 'PAGE_VIEW');
                formData.append('token', '771ecfe2cc1a7b86.70IQtxuFP4KhqPKvgXibhrX2kxW6F4BFFn_FBNI4alo.vBNC01bwU_r248CY7irJ9PG42Sf2Otl9VSiLNLNCKz-nBSnQaMxlxPX-gQ');
                fetch('/api/analytics/event/fire', {
                    method: 'POST',
                    body: formData
                })

                fbq('track', 'PageView', {}, {eventID: event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                snaptr('track', 'PAGE_VIEW', { "client_dedup_id": event_id});
            } catch (e) {
                console.log(e)
            }
        }

        ViewContent(comicid) {

            let event_id = this.getCookie('request_id') + '2';

            try {
                console.log('%c ViewContent ' + event_id + ' ', 'background: #222; color: #bada55');
                window.logOnDB(event_id, 'ViewContent')

                let formData = new FormData();
                formData.append('locale', 'en');
                formData.append('event_id', event_id);
                formData.append('event_name', 'ViewContent');
                formData.append('tiktok_event_name', 'ViewContent');
                formData.append('snap_event_name', 'VIEW_CONTENT');
                formData.append('token', '33b3fbda.B3qs33Kn4ZYTGKzblPqwiv37-dH-HU7MRonWZ6wkxVo.VCv-uz_Sje5EU57s-6ji-Lm1s-OyMBf0Bd6YV81ehD9PPZW4Ae670EdO3w');
                formData.append('value', comicid);
                fetch('/api/analytics/event/fire', {
                    method: 'POST',
                    body: formData
                })

                fbq('track', 'ViewContent', {currency: 'USD', value: comicid}, {eventID: event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                snaptr('track', 'VIEW_CONTENT', { "client_dedup_id": event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                ttq.track('ViewContent', {
                    event_id: event_id,
                    content_id: COMIC_ID,
                    content_name: COMIC_TITLE,
                    url: window.location.href,
                    email: EM_HASH,
                    external_id: EXTERNAL_ID_HASH,
                });
            } catch (e) {
                console.log(e)
            }
        }

        SubmitApplication() {

            let event_id = this.getCookie('request_id') + '7';

            try {

                if (sessionStorage.getItem('submit_application_send')) {
                    console.log('%c SubmitApplication already send ', 'background: #222; color: #bada55');
                    return;
                } else {
                    sessionStorage.setItem('submit_application_send', 1)
                }

                console.log('%c SubmitApplication ' + event_id + ' ', 'background: #222; color: #bada55');
                window.logOnDB(event_id, 'SubmitApplication')

                let formData = new FormData();
                formData.append('locale', 'en');
                formData.append('event_id', event_id);
                formData.append('event_name', 'SubmitApplication');
                formData.append('tiktok_event_name', 'SubmitForm');
                formData.append('token', '4775bfe20.yEqUTu64Yq13cF0p4Xtwf42ebV_gE6bGYg7a8PGfDKQ.mxvGKqPNDtUgO28ejikiDcnQJ22sPv_-IVmUwJDlTcGADa0pnfE46yMmLg');
                fetch('/api/analytics/event/fire', {
                    method: 'POST',
                    body: formData
                })

                fbq('track', 'SubmitApplication', {}, {eventID: event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                ttq.track('SubmitForm', {
                    event_id: event_id,
                    url: window.location.href,
                });
            } catch (e) {
                console.log(e)
            }
        }

        CompleteRegistration() {

            let event_id = this.getCookie('request_id') + '3';

            try {
                console.log('%c CompleteRegistration ' + event_id + ' ', 'background: #222; color: #bada55');
                window.logOnDB(event_id, 'CompleteRegistration')

                let formData = new FormData();
                formData.append('locale', 'en');
                formData.append('event_id', event_id);
                formData.append('event_name', 'CompleteRegistration');
                formData.append('tiktok_event_name', 'CompleteRegistration');
                formData.append('token', 'c29.wnsHu6zlWdwS2jm4E2HndVECyh1dDNrg1akph3eTWlE.kSpV3-GQNaRFkQuPfDO1BxVMgC8RIYPYlv5ntxbpGzSKPD7c36wDmkaMSg');
                fetch('/api/analytics/event/fire', {
                    method: 'POST',
                    body: formData
                })

                fbq('track', 'CompleteRegistration', {}, {eventID: event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                ttq.track('CompleteRegistration', {
                    event_id: event_id,
                    url: window.location.href,
                });
            } catch (e) {
                console.log(e)
            }
        }

        Lead(email = 'seedmnawi109@gmail.com') {

            let event_id = '6413757' + '4';
            let tt_event_id = this.getCookie('request_id') + '4';

            try {
                console.log('%c Lead ' + event_id + ' ', 'background: #222; color: #bada55');
                console.log('%c TTLead ' + tt_event_id + ' ', 'background: #222; color: #bada55');
                setTimeout(() => {
                    window.logOnDB(event_id, 'Lead')
                    window.logOnDB(tt_event_id, 'TTLead')
                }, 500)

                                                                                                                                                                                                                                
                fbq('track', 'Lead', {}, {eventID: event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                twq('event', 'tw-omuuy-omv7i', {
                    conversion_id: event_id,
                    email_address: email
                });

                twq('event', 'tw-onc8x-onc8z', {
                    conversion_id: event_id,
                    email_address: email
                });

                
                twq('event', 'tw-onjvo-onjvq', {
                    conversion_id: event_id,
                    email_address: "seedmnawi109@gmail.com"
                });

                twq('event', 'tw-onjvr-onjvt', {
                    conversion_id: event_id,
                    email_address: "seedmnawi109@gmail.com"
                });


                
                                twq('event', 'tw-onl9s-onla8', {
                    email_address: "seedmnawi109@gmail.com"
                });
                
                twq('event', 'tw-pbidu-pbidx', {
                    status: "completed",
                    conversion_id: event_id,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pdnar-pdncx', {
                    status: "completed",
                    conversion_id: event_id,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pdndi-pdne0', {
                    status: "completed",
                    conversion_id: event_id,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pdljv-pdlk1', {
                    status: "completed",
                    conversion_id: event_id,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pbjd5-pdq06', {
                    status: "completed",
                    conversion_id: event_id,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pl9ez-pl9hs', {
                    status: "completed",
                    conversion_id: event_id,
                    email_address: "seedmnawi109@gmail.com"
                });

            } catch (e) {
                console.log(e)
            }

            try {
                snaptr('track', 'SIGN_UP', {
                    "client_dedup_id": event_id,
                    "sign_up_method": "",
                    "uuid_c1": "bH4KWfnQGErm5IY14jr3eYCDxtXtjxwX",
                });
            } catch (e) {
                console.log(e)
            }

            try {
                rdt('track', 'SignUp', {
                    email: "seedmnawi109@gmail.com",
                    externalId: "6413757",
                });
            } catch (e) {
                console.log(e)
            }

            try {
                gtag("event", "sign_up", {
                    currency : "USD",
                    value : 0
                });

                function gtag_report_conversion_sign_up(url) {
                    var callback = function () {
                        if (typeof(url) != 'undefined') {
                            window.location = url;
                        }
                    };
                    gtag('event', 'conversion', {
                        'send_to': 'AW-16492688301/MRk_CN3SzbAZEK3nqbg9',
                        'value': 0,
                        'currency': 'USD',
                        'event_callback': callback
                    });
                    return false;
                }
                gtag_report_conversion_sign_up()

                function gtag_report_conversion_sign_up_8er9ger(url) {
                    var callback = function () {
                        if (typeof(url) != 'undefined') {
                            window.location = url;
                        }
                    };
                    gtag('event', 'conversion', {
                        'send_to': 'AW-16492688301/RkYTCPHB2dUZEK3nqbg9',
                        'value': 0,
                        'currency': 'USD',
                        'event_callback': callback
                    });
                    return false;
                }

                gtag_report_conversion_sign_up_8er9ger()
            } catch (e) {
                console.log(e)
            }

            try {
                ttq.track('Subscribe', {
                    event_id: tt_event_id,
                    url: window.location.href,
                    email: "b2765cd20d43aae9541c83c5abcfcf1bd19c410cf8fef40cacb03d1a2dc4f204",
                    external_id: "f49b68255dc15f6fb5b238341aad58f061cedf3849748713194bfba85cd11973",
                });
            } catch (e) {
                console.log(e)
            }

            
        }

        AddToCart() {

            let event_id = parseInt();
            event_id = event_id > 0 ? event_id : this.getCookie('request_id') + '5';

            if(parseInt() > 0){
                sessionStorage.removeItem('add-to-cart-id')
            } else {
                sessionStorage.setItem('add-to-cart-id', event_id)
            }

            if(location.search.includes('subs-change-flow')){
                console.log('%c AddToCart skip for subs-change ', 'background: #222; color: #bada55');
                return;
            }

            let Plan = JSON.parse(sessionStorage.getItem('level-data') ?? '[]');
            if ((Plan && Plan?.type === 'tokens') || location.search.includes('tokens-flow=1')) {
                console.log('%c AddToCart skip for tokens ', 'background: #222; color: #bada55');
                return;
            }

            try {
                if(document.querySelector('*[data-logger-user]').getAttribute('data-logger-user')){
                    let formData = new FormData();
                    formData.append('contact', document.querySelector('*[data-logger-user]').getAttribute('data-logger-user'));
                    formData.append('customEvent', 'view_membership_page');
                    fetch('/smart-sender/custom-event', {
                        method: 'POST',
                        body: formData
                    }).finally(() => {
                        console.log('%c smart-sender send view_membership_page ', 'background: #222; color: #bada55');
                    })
                }
            } catch (e) {
                console.log(e)
            }

            try {
                console.log('%c AddToCart ' + event_id + ' ', 'background: #222; color: #bada55');
                window.logOnDB(event_id, 'AddToCart')

                let formData = new FormData();
                formData.append('locale', 'en');
                formData.append('event_id', event_id);
                formData.append('event_name', 'AddToCart');
                formData.append('tiktok_event_name', 'AddToCart');
                formData.append('snap_event_name', 'ADD_CART');
                formData.append('token', 'a.YMlo0tLMdVFf6XDzhghzIc4N2jbjXmdvvKVISr_2eMU.M5g6tp-5GSkIokLE6VohU4pDkASvcz5X__IGet6MOaAojlG1oYUvFwu_Aw');
                fetch('/api/analytics/event/fire', {
                    method: 'POST',
                    body: formData
                })

                fbq('track', 'AddToCart', {}, {eventID: event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                snaptr('track', 'ADD_CART', { "client_dedup_id": event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                gtag("event", "begin_checkout", {
                    currency : "USD",
                    value : 0,
                    items: [{
                        item_id: 1,
                        item_name: 'start'
                    }]
                });

                function gtag_report_conversion_begin_checkout(url) {
                    var callback = function () {
                        if (typeof(url) != 'undefined') {
                            window.location = url;
                        }
                    };
                    gtag('event', 'conversion', {
                        'send_to': 'AW-16492688301/hrC8CNrSzbAZEK3nqbg9',
                        'value': 0,
                        'currency': 'USD',
                        'event_callback': callback
                    });
                    return false;
                }
                gtag_report_conversion_begin_checkout()
            } catch (e) {
                console.log(e)
            }

            try {
                ttq.track('AddToCart', {
                    event_id: event_id,
                    url: window.location.href,
                    email: "b2765cd20d43aae9541c83c5abcfcf1bd19c410cf8fef40cacb03d1a2dc4f204",
                    external_id: "f49b68255dc15f6fb5b238341aad58f061cedf3849748713194bfba85cd11973",
                });
            } catch (e) {
                console.log(e)
            }

        }

        InitiateCheckout(val, method = 'default') {

            let event_id = this.getCookie('request_id') + '6';

            if(location.search.includes('subs-change-flow')){
                console.log('%c InitiateCheckout skip for subs-change ', 'background: #222; color: #bada55');
                return;
            }

            let Plan = JSON.parse(sessionStorage.getItem('level-data') ?? '[]');
            if ((Plan && Plan?.type === 'tokens') || location.search.includes('tokens-flow=1')) {
                console.log('%c InitiateCheckout skip for tokens ', 'background: #222; color: #bada55');
                return;
            }

            try {
                if(sessionStorage.getItem('level-tier')){
                    val = sessionStorage.getItem('level-tier')
                }

                if (sessionStorage.getItem('initiate_checkout_') === event_id) {
                    console.log('%c InitiateCheckout already send ', 'background: #222; color: #bada55');
                    return;
                } else {
                    sessionStorage.setItem('initiate_checkout_', event_id)
                }

                console.log('%c InitiateCheckout ' + event_id + ' ', 'background: #222; color: #bada55');
                window.logOnDB(event_id, 'InitiateCheckout')

                let formData = new FormData();
                formData.append('locale', 'en');
                formData.append('value', val);
                formData.append('event_name', 'InitiateCheckout');
                formData.append('tiktok_event_name', 'InitiateCheckout');
                formData.append('event_id', event_id);
                formData.append('token', '823fec27af36bf05fe65c759361.GuHS7ElPxTvOD7K2Bra01ZAJid1L2WEpGbh_c-A_yCQ.SbCAiAQ6qUOZRICBaeTmp9RHw-8H9DgRWu8xQ4FFiUFSpuuLOgaffZpZwQ');
                fetch('/api/analytics/event/fire', {
                    method: 'POST',
                    body: formData
                })

                fbq('track', 'InitiateCheckout', {
                    value: val,
                    currency: 'USD'
                }, {eventID: event_id});
            } catch (e) {
                console.log(e)
            }

            try {
                let event_properties_json = JSON.stringify({
                    "type": document.querySelector('.membership-page-ht-296') ? 'pre' : 'default',
                    "method": method,
                })
                let formData = new FormData();
                formData.append('event_name', 'initiate_checkout');
                formData.append('event_properties', event_properties_json);
                fetch('/api/custom-event', {
                    method: 'POST',
                    body: formData
                }).finally(() => {
                    console.log(`%c CE initiate_checkout - ${event_properties_json} `, 'background: #222; color: #bada55');
                })
            } catch (e) {
                console.log(e)
            }

            try {
                gtag("event", "add_payment_info", {
                    currency: "USD",
                    value: val,
                    items: [{
                        item_id: JSON.parse(sessionStorage.getItem('level-data') ?? '').id,
                        item_name: JSON.parse(sessionStorage.getItem('level-data') ?? '').title
                    }]
                });
            } catch (e) {
                console.log(e)
            }

            try {
                function gtag_report_conversion(url) {
                    var callback = function () {
                        if (typeof(url) != 'undefined') {
                            window.location = url;
                        }
                    };
                    gtag('event', 'conversion', {
                        'send_to': 'AW-16492688301/rjjyCMPJ6fEZEK3nqbg9',
                        'event_callback': callback
                    });
                    return false;
                }
                gtag_report_conversion()
            } catch (e) {
                console.log(e)
            }

            try {
                ttq.track('InitiateCheckout', {
                    event_id: event_id,
                    url: window.location.href,
                    email: "b2765cd20d43aae9541c83c5abcfcf1bd19c410cf8fef40cacb03d1a2dc4f204",
                    external_id: "f49b68255dc15f6fb5b238341aad58f061cedf3849748713194bfba85cd11973",
                });
            } catch (e) {
                console.log(e)
            }
        }

        Purchase(amount, reff = '', eventID = '1') {

            if(location.search.includes('subs-change-flow')){
                console.log('%c Purchase skip for subs-change ', 'background: #222; color: #bada55');
                return;
            }

            if(eventID === '1') {
                eventID = this.getCookie('request_id') + '8'
            } else {
                eventID = eventID + '8'
            }

            this.deleteCookie('subs-change-flow')
            this.deleteCookie('subs-change-renew-if-failed')

            if (sessionStorage.getItem('purchase_' + amount + '_' + eventID)) {
                console.log('%c Purchase already send ', 'background: #222; color: #bada55');
                return;
            } else {
                sessionStorage.setItem('purchase_' + amount + '_' + eventID, 1)
            }

            let Plan = JSON.parse(sessionStorage.getItem('level-data') ?? '[]');

            if(Plan && Plan?.type === 'tokens'){
                console.log('%c Purchase skip for tokens ', 'background: #222; color: #bada55');
                return;
            }

            try {
                if(sessionStorage.getItem('level-tier')){
                    amount = sessionStorage.getItem('level-tier')
                }

                console.log('%c Purchase ' + eventID + ' ', 'background: #222; color: #bada55');
                window.logOnDB(eventID, 'Purchase')

                let formData = new FormData();
                formData.append('locale', 'en');
                formData.append('reff', reff);
                formData.append('value', amount);
                formData.append('event_name', 'Purchase');
                formData.append('tiktok_event_name', 'CompletePayment');
                formData.append('snap_event_name', 'PURCHASE');
                formData.append('event_id', eventID);
                formData.append('token', '90.AZ1_-Tim_ZKRB1_7jGVa_04bXKPXH4DOKTqQvE6j0NY.UswtnXXTkerGTG3M4zcIjQpVFpGbMtn2am3ejC_ZkbNJ2kaeS--n1MVRLA');
                fetch('/api/analytics/event/fire', {
                    method: 'POST',
                    body: formData
                })

                fbq('track', 'Purchase', {value: amount, currency: 'USD'}, {eventID: eventID});

            } catch (e) {
                console.log(e)
            }

            try {
                if(eventID === '1') {
                    eventID = this.events_ids.Purchase
                }
                snaptr('track', 'PURCHASE', {
                    'currency': 'USD',
                    'price': amount,
                    'transaction_id': eventID,
                    "client_dedup_id": eventID,
                    "uuid_c1": "bH4KWfnQGErm5IY14jr3eYCDxtXtjxwX"
                });
            } catch (e) {
                console.log(e)
            }

            try {
                rdt('track', 'Purchase', {
                    value: amount,
                    currency: "USD",
                    itemCount: 1,
                    email: "seedmnawi109@gmail.com",
                    externalId: "6413757",
                });
            } catch (e) {
                console.log(e)
            }

            try {
                if(eventID === '1') {
                    eventID = this.events_ids.Purchase
                }
                
                twq('event', 'tw-omuuy-omv7g', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });

                twq('event', 'tw-onc8x-onc8y', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });

                                twq('event', 'tw-onjvo-onjvp', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });

                twq('event', 'tw-onjvr-onjvs', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });

                
                                twq('event', 'tw-onl9s-onla7', {
                    value: amount, // use this to pass the value of the conversion (e.g. 5.00)
                    currency: "USD", // use this to pass the currency of the conversion with an ISO 4217 code (e.g. ‘USD’)
                    conversion_id: eventID, // use this to pass a unique ID for the conversion event for deduplication (e.g. order id '1a2b3c')
                    email_address: "seedmnawi109@gmail.com" // use this to pass a user’s email address
                });
                
                twq('event', 'tw-pbidu-pbidw', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pdnar-pdncb', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pdndi-pdndt', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pdljv-pdnfc', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pbjd5-pdpz6', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });
                twq('event', 'tw-pl9ez-pl9gm', {
                    value: amount,
                    currency: "USD",
                    conversion_id: eventID,
                    email_address: "seedmnawi109@gmail.com"
                });

            } catch (e) {
                console.log(e)
            }

            try {
                gtag("event", "purchase", {
                    currency : "USD",
                    value : amount,
                    transaction_id : eventID,
                    items: [{
                        item_id: JSON.parse(sessionStorage.getItem('level-data') ?? '').id,
                        item_name: JSON.parse(sessionStorage.getItem('level-data') ?? '').title,
                    }]
                });

                function gtag_report_conversion_purchase(url) {
                    var callback = function () {
                        if (typeof(url) != 'undefined') {
                            window.location = url;
                        }
                    };
                    gtag('event', 'conversion', {
                        'send_to': 'AW-16492688301/T_EkCNfSzbAZEK3nqbg9',
                        'value': amount,
                        'currency': 'USD',
                        'transaction_id': eventID,
                        'event_callback': callback
                    });
                    return false;
                }

                gtag_report_conversion_purchase()

                function gtag_report_conversion_purchase_9sr8hu(url) {
                    var callback = function () {
                        if (typeof(url) != 'undefined') {
                            window.location = url;
                        }
                    };
                    gtag('event', 'conversion', {
                        'send_to': 'AW-16492688301/qKRPCO7B2dUZEK3nqbg9',
                        'value': amount,
                        'currency': 'USD',
                        'transaction_id': '',
                        'event_callback': callback
                    });
                    return false;
                }

                gtag_report_conversion_purchase_9sr8hu()

            } catch (e) {
                console.log(e)
            }

            try {
                ttq.track('CompletePayment', {
                    event_id: eventID,
                    url: window.location.href,
                    email: "b2765cd20d43aae9541c83c5abcfcf1bd19c410cf8fef40cacb03d1a2dc4f204",
                    external_id: "f49b68255dc15f6fb5b238341aad58f061cedf3849748713194bfba85cd11973",
                    value: amount,
                    currency: 'USD',
                });
            } catch (e) {
                console.log(e)
            }

            
            try {
                function gtag_report_conversion_17015643201(url) {
                    var callback = function () {
                        if (typeof(url) != 'undefined') {
                            window.location = url;
                        }
                    };
                    gtag('event', 'conversion', {
                        'send_to': 'AW-17015643201/nqldCN6Bh7waEMG42LE_',
                        'value': 1.0,
                        'currency': 'USD',
                        'transaction_id': '',
                        'event_callback': callback
                    });
                    return false;
                }
                gtag_report_conversion_17015643201()

                function gtag_report_conversion_17006693195(url) {
                    var callback = function () {
                        if (typeof(url) != 'undefined') {
                            window.location = url;
                        }
                    };
                    gtag('event', 'conversion', {
                        'send_to': 'AW-17006693195/DmpdCMOqgbwaEMuWtq0_',
                        'value': 1.0,
                        'currency': 'USD',
                        'transaction_id': '',
                        'event_callback': callback
                    });
                    return false;
                }
                gtag_report_conversion_17006693195()
            } catch (e) {
                console.warn(e)
            }

        }

        getCookie(name) {
            const value = `; ${document.cookie}`;
            const parts = value.split(`; ${name}=`);
            if (parts.length === 2) return parts.pop().split(';').shift();
        }

        deleteCookie(name) {
            document.cookie = name +'=; Path=/; Expires=Thu, 01 Jan 1970 00:00:01 GMT;';
        }
    }

    window.fbca = new fbca();
    window.abtData = {}
</script>



                                
                            
    
                                                                                
        
                
                
    
                                            
        <!-- Snap Pixel Code -->
    <script type='text/javascript'>
        (function(e,t,n){if(e.snaptr)return;var a=e.snaptr=function()
        {a.handleRequest?a.handleRequest.apply(a,arguments):a.queue.push(arguments)};
            a.queue=[];var s='script';r=t.createElement(s);r.async=!0;
            r.src=n;var u=t.getElementsByTagName(s)[0];
            u.parentNode.insertBefore(r,u);})(window,document,
            'https://sc-static.net/scevent.min.js');

                snaptr('init', 'd23cb2e9-5122-456c-b782-1a14a332b223', {
            'user_email': 'seedmnawi109@gmail.com'
        });
        
                snaptr('init', 'ef4bf4fe-c282-409e-8c62-cdf0feaf861c', {
            'user_email': 'seedmnawi109@gmail.com'
        });
        
        
    </script>
    <!-- End Snap Pixel Code -->
    
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-NBQB6VEZG7"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-NBQB6VEZG7');
    </script>

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-16492688301"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'AW-16492688301');
    </script>

    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-NV8MBFF');</script>
    <!-- End Google Tag Manager -->

            <!-- Hotjar Tracking Code for Site 5191204 (name missing) -->
        <script>
            (function(h,o,t,j,a,r){
                h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};
                h._hjSettings={hjid:5191204,hjsv:6};
                a=o.getElementsByTagName('head')[0];
                r=o.createElement('script');r.async=1;
                r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;
                a.appendChild(r);
            })(window,document,'https://static.hotjar.com/c/hotjar-','.js?sv=');
        </script>
    
    



    <script>
        window.logOnDB = function (requestId = '', eventName = ''){}
    </script>

<script>
    document.addEventListener('DOMContentLoaded', function (event) {
        window.dataLayer.push({
            'visitor_key': '1efd71cb-586e-6c24-a7c7-839539337942',
            'platform': 'en',
            'language': 'GB',
        })

                window.dataLayer.push({'user_id': "6413757"})
        
                                                                                                                })
</script>

<script async src="https://www.googletagmanager.com/gtag/js?id=AW-17006693195"></script>
<script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'AW-17006693195');
</script>
<script async src="https://www.googletagmanager.com/gtag/js?id=AW-17015643201"></script>
<script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'AW-17015643201');
</script>

                <script src="build/runtime.32c4cf58.js" defer></script><script src="build/796.a02e4896.js" defer></script><script src="build/835.3a131f90.js" defer></script><script src="build/420.e4591646.js" defer></script><script src="build/916.080caaf2.js" defer></script><script src="build/987.d48e9d73.js" defer></script><script src="build/273.593423f0.js" defer></script><script src="build/app.b432fc34.js" defer></script>
        <script>
            const API_NOTIFICATIONS_GET_UNREAD_PATH = '/api/notifications/get-unread'
            const APP_REAL_LOCALE = 'en'
        </script>
        <script>
            let interval = setInterval(function () {
                if(document.querySelectorAll('.preview-card__image-size')){
                    document.querySelectorAll('.preview-card__image-size').forEach(function (elm) {
                        elm.previousElementSibling.style.minHeight = elm.offsetHeight + 'px'
                    })
                }
            }, 100)

            document.addEventListener('DOMContentLoaded', function(event) {
                clearInterval(interval)
            })
        </script>
    </head>

            


<header class="header"
        data-user-has-premium="1"
        data-is-uncensored-available="1"
        data-logger-user="6413757"
        data-custom_event_token="3eebe0b2465c88f03.0L3TBOZa5_wmtaHWNY3YAJmITp3axdQ0OfF-g1YWVVc.uu-xV5dtpptO1s2iYvW1c-OlY_Syqbx-fa488Q5wNAKhiItspw6BpVDR5A">
    <div class="container">
        <div class="header-inner" >
            <a href="comic/the-head-of-a-womens-association.html" class="header__logo" data-ga-event='{"event":"click","element":"logo","element_location":"gnav"}'>
                <img src="build/images/logo/logo.svg@t=9723654" alt="logo">
            </a>
                            <div class="header-top-row">
                    <a href="comic/the-head-of-a-womens-association.html" class="header__logo" data-ga-event='{"event":"click","element":"logo","element_location":"gnav"}'>
                        <img src="build/images/logo/logo.svg@t=9723654" alt="logo">
                    </a>

                    <div class="search-form-wrap">
                        <form class="search-form search-form-js"
                              data-trans-placeholder="Search comics..."
                              data-trans-popular-searches="popular searches"
                              data-trans-popular-tags="popular tags"
                              data-trans-results-for="results for"
                              data-trans-show-all-results="Show All Results"
                              data-trans-no-matches="No Matches Were Found"
                              action="comic/the-head-of-a-womens-association.html">
                            <div class="search-form__search">
                                <button class="search-form__btn" type="submit" aria-label="search-btn">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7.33333 1.33333C10.6453 1.33333 13.3333 4.02133 13.3333 7.33333C13.3333 10.6453 10.6453 13.3333 7.33333 13.3333C4.02133 13.3333 1.33333 10.6453 1.33333 7.33333C1.33333 4.02133 4.02133 1.33333 7.33333 1.33333ZM7.33333 12C9.91133 12 12 9.91133 12 7.33333C12 4.75467 9.91133 2.66667 7.33333 2.66667C4.75466 2.66667 2.66666 4.75467 2.66666 7.33333C2.66666 9.91133 4.75466 12 7.33333 12ZM12.99 12.0473L14.876 13.9327L13.9327 14.876L12.0473 12.99L12.99 12.0473Z"
                                              fill="#666666"/>
                                    </svg>
                                </button>
                                <input class="search-form__input" id="autoComplete" autocomplete="off" type="text" value="" required="" minlength="2" maxlength="700" tabindex="1">
                                <svg class="search-form__close" width="16" height="16" viewBox="0 0 16 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8.00048 7.05781L11.3005 3.75781L12.2431 4.70048L8.94315 8.00048L12.2431 11.3005L11.3005 12.2431L8.00048 8.94315L4.70048 12.2431L3.75781 11.3005L7.05781 8.00048L3.75781 4.70048L4.70048 3.75781L8.00048 7.05781Z"
                                          fill="#FF514D"/>
                                </svg>
                            </div>
                        </form>
                    </div>

                    <button class="search-btn search-btn-js">
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12.0213 11.0787L14.8767 13.9333L13.9333 14.8767L11.0787 12.0213C10.0165 12.8728 8.69532 13.3359 7.33398 13.334C4.02198 13.334 1.33398 10.646 1.33398 7.33398C1.33398 4.02198 4.02198 1.33398 7.33398 1.33398C10.646 1.33398 13.334 4.02198 13.334 7.33398C13.3359 8.69532 12.8728 10.0165 12.0213 11.0787ZM10.684 10.584C11.5301 9.71391 12.0026 8.5476 12.0007 7.33398C12.0007 4.75532 9.91198 2.66732 7.33398 2.66732C4.75532 2.66732 2.66732 4.75532 2.66732 7.33398C2.66732 9.91198 4.75532 12.0007 7.33398 12.0007C8.5476 12.0026 9.71391 11.5301 10.584 10.684L10.684 10.584Z"
                                  fill="black"/>
                        </svg>
                    </button>

                    
                    <div class="header-btns-switch-age">
                                                    <div class="switch-age-wrap" >
                                <div class="switch-age" data-ga-event='{"event":"click","element":"r_toggle","action":"18_minus","element_location":"gnav"}' >
                                    <input type="checkbox"
                                           id="switch-age" checked="checked">
                                    <div class="switch-age__color en"></div>
                                </div>
                            </div>
                        

                        <div class="header-btns">
                                                                                                <a href="https://honeytoon.com/account"
                                       data-ga-event='{"event":"click","element":"account","element_location":"menu","state":"current_user"}'
                                       rel="nofollow"
                                       class="btn btn-yellow">
                                        <img class="btn-icon--before" data-loading="lazy" width="16" height="16"
                                             src="build/images/icon/premium-icon.svg"
                                             alt="premium icon">
                                        Account
                                    </a>
                                                                                    </div>

                        <div class="hamburger-menu">
                            <input id="menu__toggle" type="checkbox"/>
                            <label class="menu__btn" for="menu__toggle">
                                <span></span>
                            </label>

                            <nav class="menu__box">
                                <div class="menu__box-inner">
                                    <ul class="menu__list">
                                        <li class="menu__item">
                                            <a href="mylibrary.html" class="menu__link" data-ga-event='{"event":"click","element":"my_library","element_location":"menu"}'>
                                                <div class="menu__link-icon">
                                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M9.83317 15.5V17.1667H8.1665V15.5H1.49984C1.27882 15.5 1.06686 15.4122 0.910582 15.2559C0.754301 15.0996 0.666504 14.8877 0.666504 14.6667V1.33334C0.666504 1.11232 0.754301 0.90036 0.910582 0.74408C1.06686 0.5878 1.27882 0.500002 1.49984 0.500002H6.49984C6.97283 0.499441 7.44049 0.599799 7.8716 0.794375C8.30272 0.988951 8.68736 1.27327 8.99984 1.62834C9.31232 1.27327 9.69696 0.988951 10.1281 0.794375C10.5592 0.599799 11.0268 0.499441 11.4998 0.500002H16.4998C16.7209 0.500002 16.9328 0.5878 17.0891 0.74408C17.2454 0.90036 17.3332 1.11232 17.3332 1.33334V14.6667C17.3332 14.8877 17.2454 15.0996 17.0891 15.2559C16.9328 15.4122 16.7209 15.5 16.4998 15.5H9.83317ZM15.6665 13.8333V2.16667H11.4998C11.0578 2.16667 10.6339 2.34226 10.3213 2.65482C10.0088 2.96738 9.83317 3.39131 9.83317 3.83334V13.8333H15.6665ZM8.1665 13.8333V3.83334C8.1665 3.39131 7.99091 2.96738 7.67835 2.65482C7.36579 2.34226 6.94186 2.16667 6.49984 2.16667H2.33317V13.8333H8.1665Z"
                                                              fill="#FFDB26"/>
                                                    </svg>
                                                </div>
                                                My Library
                                            </a>
                                        </li>
                                        <li class="menu__item">
                                            <a href="genres.html" class="menu__link menu__link--genres" data-ga-event='{"event":"click","element":"genres","element_location":"menu"}'>
                                                <div class="menu__link-icon">
                                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M7.52994 19.9982L8.1021 15.6405L6.51554 14.6189L6.82652 13.4633L2.38841 14.203L0 0.00170898L20 1.26487L17.4132 11.6989L11.1821 12.7374L11.0394 13.0435L13.1502 14.6515L7.52994 19.9982ZM7.87006 14.0968L9.36111 15.0569L9.12388 16.8638L11.3454 14.7504L9.57787 13.4039L10.3806 11.6825L16.4608 10.6691L18.5241 2.34628L1.40118 1.26487L3.35029 12.8542L8.43238 12.0072L7.87006 14.0968Z" fill="#6FC2FF" stroke="#6FC2FF" stroke-width="0.5"/>
                                                    </svg>
                                                </div>
                                                Comics
                                            </a>
                                        </li>
                                        <li class="menu__item">
                                            <a href="new.html" class="menu__link menu__link--new" data-ga-event='{"event":"click","element":"new_stories","element_location":"menu"}'>
                                                <div class="menu__link-icon">
                                                    <svg width="15" height="20" viewBox="0 0 15 20" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M7.83398 7.5H14.5007L6.16732 20V12.5H0.333984L7.83398 0V7.5ZM6.16732 9.16667V6.01667L3.27732 10.8333H7.83398V14.495L11.3865 9.16667H6.16732Z"
                                                              fill="#C7FF80"/>
                                                    </svg>
                                                </div>
                                                New
                                            </a>
                                        </li>

                                                                                <li class="menu__item menu__item--manga">
                                            <a href="manga-genres.html" class="menu__link menu__link--manga" data-ga-event='{"event":"click","element":"manga","element_location":"gnav"}'>
                                                <div class="menu__link-icon">
                                                    <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M14.125 0H4.125C3.17728 0 2.40625 0.771031 2.40625 1.71875V14.2812C2.40625 15.229 3.17728 16 4.125 16H14.125C14.3839 16 14.5938 15.7901 14.5938 15.5312V0.46875C14.5938 0.209875 14.3839 0 14.125 0ZM4.125 0.9375H13.6562V12.5625H4.125C3.84375 12.5625 3.57834 12.6308 3.34375 12.7511V1.71875C3.34375 1.28797 3.69422 0.9375 4.125 0.9375ZM13.6562 15.0625H4.125C3.69422 15.0625 3.34375 14.712 3.34375 14.2812C3.34375 13.8505 3.69422 13.5 4.125 13.5H13.6562V15.0625Z" fill="#E6AFFF"/>
                                                        <path d="M5.06249 7.5H5.22271C5.22096 7.53678 5.21989 7.57356 5.21939 7.61037L4.6013 11.0099C4.55499 11.2646 4.72393 11.5086 4.97865 11.5549C5.23336 11.6012 5.4774 11.4323 5.52371 11.1776L5.82008 9.54747C6.41486 10.3878 7.3944 10.9375 8.49999 10.9375C9.60555 10.9375 10.5851 10.3878 11.1799 9.54747L11.4763 11.1776C11.5226 11.4323 11.7666 11.6012 12.0213 11.5549C12.2761 11.5086 12.445 11.2646 12.3987 11.0099L11.7806 7.61037C11.7801 7.57356 11.779 7.53675 11.7773 7.5H11.9375C12.1964 7.5 12.4062 7.29012 12.4062 7.03125C12.4062 6.27759 12.1868 5.54359 11.7801 4.91509C12.1687 4.59572 12.4062 4.11528 12.4062 3.59375C12.4062 2.64603 11.6352 1.875 10.6875 1.875C9.88905 1.875 9.21605 2.42216 9.02383 3.16128C8.67477 3.11303 8.32524 3.11303 7.97618 3.16128C7.78393 2.42216 7.11093 1.875 6.31249 1.875C5.36477 1.875 4.59374 2.64603 4.59374 3.59375C4.59374 4.11528 4.83127 4.59572 5.21983 4.91509C4.81318 5.54359 4.59374 6.27759 4.59374 7.03125C4.59374 7.29012 4.80361 7.5 5.06249 7.5ZM8.49999 10C7.20765 10 6.15624 8.94859 6.15624 7.65625C6.15624 7.60409 6.15818 7.55197 6.16161 7.5H10.8384C10.8418 7.55197 10.8437 7.60409 10.8437 7.65625C10.8437 8.94859 9.79233 10 8.49999 10ZM6.31249 2.8125C6.74327 2.8125 7.09374 3.16297 7.0938 3.59072C7.09346 3.59656 7.09118 3.61359 7.08946 3.62603C7.08708 3.64362 7.08474 3.66122 7.0828 3.67894C7.04646 4.01034 7.35796 4.27269 7.67836 4.1805C7.95055 4.10222 8.22699 4.0625 8.49999 4.0625C8.77299 4.0625 9.04943 4.10222 9.32158 4.18053C9.64199 4.27272 9.95352 4.01038 9.91718 3.67897C9.91524 3.66125 9.9129 3.64366 9.91052 3.62606C9.9088 3.61362 9.90652 3.59659 9.90624 3.59378C9.90624 3.163 10.2567 2.81253 10.6875 2.81253C11.1183 2.81253 11.4687 3.163 11.4687 3.59378C11.4687 3.92531 11.2548 4.22066 10.9364 4.32869C10.6203 4.43594 10.5144 4.82972 10.734 5.081C11.1033 5.50359 11.3433 6.01756 11.4312 6.5625H5.5688C5.65668 6.01756 5.89668 5.50359 6.26596 5.081C6.48555 4.82969 6.37964 4.43591 6.06361 4.32869C5.74521 4.22063 5.53124 3.92528 5.53124 3.59375C5.53124 3.16297 5.88171 2.8125 6.31249 2.8125Z" fill="#E6AFFF"/>
                                                    </svg>
                                                </div>
                                                Manga
                                            </a>
                                        </li>
                                                                                <li class="menu__item">
                                            <a href="popular.html" class="menu__link menu__link--popular" data-ga-event='{"event":"click","element":"popular_stories","element_location":"menu"}'>
                                                <div class="menu__link-icon">
                                                    <svg width="14" height="19" viewBox="0 0 14 19" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M6.99947 18.1667C8.65707 18.1667 10.2468 17.5082 11.4189 16.3361C12.591 15.164 13.2495 13.5743 13.2495 11.9167C13.2495 11.195 13.0578 10.5025 12.8328 9.85833C11.4436 11.2308 10.3886 11.9167 9.66613 11.9167C12.9953 6.08333 11.1661 3.58333 6.16613 0.25C6.5828 4.41667 3.83613 6.31167 2.7178 7.36417C1.80557 8.22223 1.17217 9.33456 0.899704 10.5569C0.627242 11.7793 0.728294 13.0554 1.18976 14.2196C1.65122 15.3839 2.45181 16.3826 3.48772 17.0864C4.52364 17.7902 5.74709 18.1666 6.99947 18.1667V18.1667ZM7.59113 3.3625C10.292 5.65417 10.3053 7.435 8.21864 11.0908C7.58447 12.2017 8.38697 13.5833 9.66613 13.5833C10.2395 13.5833 10.8195 13.4167 11.432 13.0875C11.2504 13.7733 10.9121 14.4076 10.4438 14.9405C9.97539 15.4733 9.38972 15.8902 8.73286 16.1582C8.076 16.4263 7.36588 16.5381 6.65843 16.4851C5.95098 16.432 5.2655 16.2154 4.65597 15.8524C4.04645 15.4894 3.52951 14.9898 3.14587 14.3931C2.76223 13.7963 2.52236 13.1186 2.44515 12.4134C2.36794 11.7082 2.45549 10.9947 2.70091 10.329C2.94634 9.66339 3.34293 9.06381 3.85947 8.5775C3.96447 8.47917 4.49697 8.00667 4.5203 7.98583C4.87363 7.66917 5.16447 7.38833 5.45197 7.08083C6.47697 5.9825 7.21363 4.76417 7.5903 3.3625H7.59113Z"
                                                              fill="#FFC68C"/>
                                                    </svg>
                                                </div>
                                                Popular
                                            </a>
                                        </li>
                                        <li class="menu__item menu__item--last">
                                            <a href="contact-us.html"
                                               class="menu__link menu__link--contacts" data-ga-event='{"event":"click","element":"contact_support","element_location":"menu"}'>
                                                <div class="menu__link-icon">
                                                    <svg width="18" height="17" viewBox="0 0 18 17" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M8.99935 2.33268C7.23124 2.33268 5.53555 3.03506 4.2853 4.2853C3.03506 5.53555 2.33268 7.23124 2.33268 8.99935H4.83268C5.27471 8.99935 5.69863 9.17494 6.01119 9.4875C6.32375 9.80007 6.49935 10.224 6.49935 10.666V14.8327C6.49935 15.2747 6.32375 15.6986 6.01119 16.0112C5.69863 16.3238 5.27471 16.4993 4.83268 16.4993H2.33268C1.89065 16.4993 1.46673 16.3238 1.15417 16.0112C0.84161 15.6986 0.666016 15.2747 0.666016 14.8327V8.99935C0.666016 4.39685 4.39685 0.666016 8.99935 0.666016C13.6018 0.666016 17.3327 4.39685 17.3327 8.99935V14.8327C17.3327 15.2747 17.1571 15.6986 16.8445 16.0112C16.532 16.3238 16.108 16.4993 15.666 16.4993H13.166C12.724 16.4993 12.3001 16.3238 11.9875 16.0112C11.6749 15.6986 11.4993 15.2747 11.4993 14.8327V10.666C11.4993 10.224 11.6749 9.80007 11.9875 9.4875C12.3001 9.17494 12.724 8.99935 13.166 8.99935H15.666C15.666 7.23124 14.9636 5.53555 13.7134 4.2853C12.4632 3.03506 10.7675 2.33268 8.99935 2.33268V2.33268ZM2.33268 10.666V14.8327H4.83268V10.666H2.33268ZM13.166 10.666V14.8327H15.666V10.666H13.166Z"
                                                              fill="#FFDB26"/>
                                                    </svg>
                                                </div>
                                                Contact support
                                            </a>
                                        </li>
                                    </ul>

                                    <div class="header-btn-inner">
                                                                                                                                    <a href="https://honeytoon.com/account"
                                                   rel="nofollow"
                                                   data-ga-event='{"event":"click","element":"account","element_location":"menu","state":"current_user"}'
                                                   class="header-btn header-btn-premium">
                                                    <div class="header-btn__icon">
                                                        <svg width="38" height="38" viewBox="0 0 38 38" fill="none"
                                                             xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M3.16602 30.0827H34.8327V33.2493H3.16602V30.0827ZM3.16602 7.91602L11.0827 12.666L18.9993 3.16602L26.916 12.666L34.8327 7.91602V26.916H3.16602V7.91602Z"
                                                                  fill="black"/>
                                                        </svg>
                                                    </div>
                                                    <span class="header-btn__title">
                                                        My Premium Account
                                                        <span>
                                                            0 days of unlimited access
                                                        </span>
                                            </span>
                                                </a>
                                                                                    
                                    </div>
                                </div>
                            </nav>
                        </div>
                    </div>

                </div>

                <nav class="header-menu">
                    <ul class="header-menu__list">
                        <li class="header-menu__item header-menu__item--home hide-all">
                            <a href="comic/the-head-of-a-womens-association.html" class="header-menu__link header-menu__link--home">
                           <span class="header-menu__link-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="16" viewBox="0 0 17 16"
                                     fill="none">
                                  <g clip-path="url(#clip0_2472_100952)">
                                    <path d="M13.0664 14H3.73307C3.55626 14 3.38669 13.9298 3.26167 13.8048C3.13664 13.6797 3.06641 13.5102 3.06641 13.3334V7.33336H1.06641L7.95107 1.07469C8.07381 0.963013 8.23379 0.901123 8.39974 0.901123C8.56568 0.901123 8.72567 0.963013 8.84841 1.07469L15.7331 7.33336H13.7331V13.3334C13.7331 13.5102 13.6628 13.6797 13.5378 13.8048C13.4128 13.9298 13.2432 14 13.0664 14ZM9.06641 12.6667H12.3997V6.10469L8.39974 2.46869L4.39974 6.10469V12.6667H7.73307V8.66669H9.06641V12.6667Z"
                                          fill="#C7FF80"/>
                                  </g>
                                  <defs>
                                    <clipPath id="clip0_2472_100952">
                                      <rect width="16" height="16" fill="white" transform="translate(0.399902)"/>
                                    </clipPath>
                                  </defs>
                                </svg>
                            </span>
                                Home
                            </a>
                        </li>
                        <li class="header-menu__item header-menu__item--my_library">
                            <a href="mylibrary.html"
                               data-ga-event='{"event":"click","element":"my_library","element_location":"gnav"}'
                               class="header-menu__link header-menu__link--my_library">
                               <span class="header-menu__link-icon">
                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9.83317 15.5V17.1667H8.1665V15.5H1.49984C1.27882 15.5 1.06686 15.4122 0.910582 15.2559C0.754301 15.0996 0.666504 14.8877 0.666504 14.6667V1.33334C0.666504 1.11232 0.754301 0.90036 0.910582 0.74408C1.06686 0.5878 1.27882 0.500002 1.49984 0.500002H6.49984C6.97283 0.499441 7.44049 0.599799 7.8716 0.794375C8.30272 0.988951 8.68736 1.27327 8.99984 1.62834C9.31232 1.27327 9.69696 0.988951 10.1281 0.794375C10.5592 0.599799 11.0268 0.499441 11.4998 0.500002H16.4998C16.7209 0.500002 16.9328 0.5878 17.0891 0.74408C17.2454 0.90036 17.3332 1.11232 17.3332 1.33334V14.6667C17.3332 14.8877 17.2454 15.0996 17.0891 15.2559C16.9328 15.4122 16.7209 15.5 16.4998 15.5H9.83317ZM15.6665 13.8333V2.16667H11.4998C11.0578 2.16667 10.6339 2.34226 10.3213 2.65482C10.0088 2.96738 9.83317 3.39131 9.83317 3.83334V13.8333H15.6665ZM8.1665 13.8333V3.83334C8.1665 3.39131 7.99091 2.96738 7.67835 2.65482C7.36579 2.34226 6.94186 2.16667 6.49984 2.16667H2.33317V13.8333H8.1665Z"
                                              fill="#FFDB26"/>
                                    </svg>
                                </span>
                                My Library
                            </a>
                        </li>
                        <li class="header-menu__item">
                            <a href="genres.html" class="header-menu__link header-menu__link--genres" data-ga-event='{"event":"click","element":"genres","element_location":"gnav"}'>
                               <span class="header-menu__link-icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7.52994 19.9982L8.1021 15.6405L6.51554 14.6189L6.82652 13.4633L2.38841 14.203L0 0.00170898L20 1.26487L17.4132 11.6989L11.1821 12.7374L11.0394 13.0435L13.1502 14.6515L7.52994 19.9982ZM7.87006 14.0968L9.36111 15.0569L9.12388 16.8638L11.3454 14.7504L9.57787 13.4039L10.3806 11.6825L16.4608 10.6691L18.5241 2.34628L1.40118 1.26487L3.35029 12.8542L8.43238 12.0072L7.87006 14.0968Z" fill="#6FC2FF" stroke="#6FC2FF" stroke-width="0.5"/>
                                    </svg>
                                </span>
                                Comics
                            </a>
                        </li>


                                                    <li class="header-menu__item">
                                <a href="manga-genres.html" class="header-menu__link header-menu__link--manga" data-ga-event='{"event":"click","element":"manga","element_location":"gnav"}'>
                                   <div class="header-menu__link-icon">
                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M14.125 0H4.125C3.17728 0 2.40625 0.771031 2.40625 1.71875V14.2812C2.40625 15.229 3.17728 16 4.125 16H14.125C14.3839 16 14.5938 15.7901 14.5938 15.5312V0.46875C14.5938 0.209875 14.3839 0 14.125 0ZM4.125 0.9375H13.6562V12.5625H4.125C3.84375 12.5625 3.57834 12.6308 3.34375 12.7511V1.71875C3.34375 1.28797 3.69422 0.9375 4.125 0.9375ZM13.6562 15.0625H4.125C3.69422 15.0625 3.34375 14.712 3.34375 14.2812C3.34375 13.8505 3.69422 13.5 4.125 13.5H13.6562V15.0625Z" fill="#E6AFFF"/>
                                            <path d="M5.06249 7.5H5.22271C5.22096 7.53678 5.21989 7.57356 5.21939 7.61037L4.6013 11.0099C4.55499 11.2646 4.72393 11.5086 4.97865 11.5549C5.23336 11.6012 5.4774 11.4323 5.52371 11.1776L5.82008 9.54747C6.41486 10.3878 7.3944 10.9375 8.49999 10.9375C9.60555 10.9375 10.5851 10.3878 11.1799 9.54747L11.4763 11.1776C11.5226 11.4323 11.7666 11.6012 12.0213 11.5549C12.2761 11.5086 12.445 11.2646 12.3987 11.0099L11.7806 7.61037C11.7801 7.57356 11.779 7.53675 11.7773 7.5H11.9375C12.1964 7.5 12.4062 7.29012 12.4062 7.03125C12.4062 6.27759 12.1868 5.54359 11.7801 4.91509C12.1687 4.59572 12.4062 4.11528 12.4062 3.59375C12.4062 2.64603 11.6352 1.875 10.6875 1.875C9.88905 1.875 9.21605 2.42216 9.02383 3.16128C8.67477 3.11303 8.32524 3.11303 7.97618 3.16128C7.78393 2.42216 7.11093 1.875 6.31249 1.875C5.36477 1.875 4.59374 2.64603 4.59374 3.59375C4.59374 4.11528 4.83127 4.59572 5.21983 4.91509C4.81318 5.54359 4.59374 6.27759 4.59374 7.03125C4.59374 7.29012 4.80361 7.5 5.06249 7.5ZM8.49999 10C7.20765 10 6.15624 8.94859 6.15624 7.65625C6.15624 7.60409 6.15818 7.55197 6.16161 7.5H10.8384C10.8418 7.55197 10.8437 7.60409 10.8437 7.65625C10.8437 8.94859 9.79233 10 8.49999 10ZM6.31249 2.8125C6.74327 2.8125 7.09374 3.16297 7.0938 3.59072C7.09346 3.59656 7.09118 3.61359 7.08946 3.62603C7.08708 3.64362 7.08474 3.66122 7.0828 3.67894C7.04646 4.01034 7.35796 4.27269 7.67836 4.1805C7.95055 4.10222 8.22699 4.0625 8.49999 4.0625C8.77299 4.0625 9.04943 4.10222 9.32158 4.18053C9.64199 4.27272 9.95352 4.01038 9.91718 3.67897C9.91524 3.66125 9.9129 3.64366 9.91052 3.62606C9.9088 3.61362 9.90652 3.59659 9.90624 3.59378C9.90624 3.163 10.2567 2.81253 10.6875 2.81253C11.1183 2.81253 11.4687 3.163 11.4687 3.59378C11.4687 3.92531 11.2548 4.22066 10.9364 4.32869C10.6203 4.43594 10.5144 4.82972 10.734 5.081C11.1033 5.50359 11.3433 6.01756 11.4312 6.5625H5.5688C5.65668 6.01756 5.89668 5.50359 6.26596 5.081C6.48555 4.82969 6.37964 4.43591 6.06361 4.32869C5.74521 4.22063 5.53124 3.92528 5.53124 3.59375C5.53124 3.16297 5.88171 2.8125 6.31249 2.8125Z" fill="#E6AFFF"/>
                                        </svg>
                                    </div>
                                    Manga

                                </a>
                                <span class="header-menu__item-label">NEW</span>
                            </li>
                        
                        <li class="header-menu__item">
                            <a href="new.html" class="header-menu__link header-menu__link--new" data-ga-event='{"event":"click","element":"new_stories","element_location":"gnav"}'>
                                <div class="header-menu__link-icon">
                                    <svg width="15" height="20" viewBox="0 0 15 20" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7.83398 7.5H14.5007L6.16732 20V12.5H0.333984L7.83398 0V7.5ZM6.16732 9.16667V6.01667L3.27732 10.8333H7.83398V14.495L11.3865 9.16667H6.16732Z"
                                              fill="#C7FF80"/>
                                    </svg>
                                </div>
                                New
                            </a>
                        </li>
                        <li class="header-menu__item">
                            <a href="popular.html" class="header-menu__link header-menu__link--popular" data-ga-event='{"event":"click","element":"popular_stories","element_location":"gnav"}'>
                                <div class="header-menu__link-icon">
                                    <svg width="14" height="19" viewBox="0 0 14 19" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.99947 18.1667C8.65707 18.1667 10.2468 17.5082 11.4189 16.3361C12.591 15.164 13.2495 13.5743 13.2495 11.9167C13.2495 11.195 13.0578 10.5025 12.8328 9.85833C11.4436 11.2308 10.3886 11.9167 9.66613 11.9167C12.9953 6.08333 11.1661 3.58333 6.16613 0.25C6.5828 4.41667 3.83613 6.31167 2.7178 7.36417C1.80557 8.22223 1.17217 9.33456 0.899704 10.5569C0.627242 11.7793 0.728294 13.0554 1.18976 14.2196C1.65122 15.3839 2.45181 16.3826 3.48772 17.0864C4.52364 17.7902 5.74709 18.1666 6.99947 18.1667V18.1667ZM7.59113 3.3625C10.292 5.65417 10.3053 7.435 8.21864 11.0908C7.58447 12.2017 8.38697 13.5833 9.66613 13.5833C10.2395 13.5833 10.8195 13.4167 11.432 13.0875C11.2504 13.7733 10.9121 14.4076 10.4438 14.9405C9.97539 15.4733 9.38972 15.8902 8.73286 16.1582C8.076 16.4263 7.36588 16.5381 6.65843 16.4851C5.95098 16.432 5.2655 16.2154 4.65597 15.8524C4.04645 15.4894 3.52951 14.9898 3.14587 14.3931C2.76223 13.7963 2.52236 13.1186 2.44515 12.4134C2.36794 11.7082 2.45549 10.9947 2.70091 10.329C2.94634 9.66339 3.34293 9.06381 3.85947 8.5775C3.96447 8.47917 4.49697 8.00667 4.5203 7.98583C4.87363 7.66917 5.16447 7.38833 5.45197 7.08083C6.47697 5.9825 7.21363 4.76417 7.5903 3.3625H7.59113Z"
                                              fill="#FFC68C"/>
                                    </svg>
                                </div>
                                Popular
                            </a>
                        </li>
                                            </ul>
                </nav>
            
        </div>
    </div>
</header>
    
    <main>
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-NV8MBFF" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        
        <h1 style="font-size: 0;line-height: 0;">Honeytoon - unlimited comics &amp; webtoons to read online</h1>
    
        
        
                        <section class="main-slider skeleton" data-placement="slider">

        <div class="main-slider-swiper swiper-container">
            <div class="swiper-wrapper">
                                
                    
                        <div class="main-slider__slide swiper-slide" onclick="window.location.assign('/comic/stepmom-comes-first')" style="background: #f09e00;">
                            <picture>
                                <source media="(min-width: 768px)"  srcset="https://pic.honeytoon.com/uploads/s31-single/b6298b7b-9b4d-45ff-82fa-d8452d262bee-1738849276-85.webp">
                                <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/9dc19ca4-ce35-4ce4-97e1-8db43ab1555e-1738849270-80.webp" class="main-slider__slide-bg" alt="Image">
                            </picture>
                                                                                    <div class="main-slider__slide-content">
                                <div class="main-slider__slide-content__logo">
                                    <picture>
                                        <source media="(min-width: 992px)" srcset="https://pic.honeytoon.com/uploads/s31-single/b5d0a04e-0943-4271-b0cf-98c75e7ba285-1734600014-19.webp">
                                        <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/7429fc8a-ef37-4302-8e25-416d60c86209-1734600010-45.webp" class="main-slider__slide-content__logo" alt="Image">
                                    </picture>
                                                                                                        </div>
                                                                    <div class="main-slider__slide-content__labels label">
                                                                                    <span class="label__item label__item--in-law" style="background-color: #ffc68c;">In-Law</span>
                                                                                    <span class="label__item label__item--cheating" style="background-color: #ffff99;">Cheating</span>
                                                                            </div>
                                                                <p class="main-slider__slide-content__desc">
                                    Fresh out of the Army, Stefan joins his dad, Hugh, and his captivating stepmom, Lillian, for a quick getaway at a resort. What starts as harmless fun turns into undeniable tension as Stefan and Lillian grapple with a forbidden attraction they can’t ignore. With only two days together and Hugh completely unaware, they’re walking a fine line between temptation and secrecy. Will they resist the pull, or will their hidden desires change everything?
                                </p>
                                <div class="main-slider__slide-content__btns btn-wrap">
                                    <a href="comic/stepmom-comes-first/prologue.html" class="btn btn-yellow">
                                        Read now
                                    </a>
                                </div>
                            </div>
                        </div>

                    
                
                    
                        <div class="main-slider__slide swiper-slide" onclick="window.location.assign('/comic/three-sisters')" style="background: #012405;">
                            <picture>
                                <source media="(min-width: 768px)"  srcset="https://pic.honeytoon.com/uploads/s31-single/bdd14c49-1cc4-474a-b7db-b3ba210d366e-1738695183-62.webp">
                                <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/0585ca2b-31f3-4e68-ad25-6db83af5db71-1738695189-88.webp" class="main-slider__slide-bg" alt="Image">
                            </picture>
                                                                                    <div class="main-slider__slide-content">
                                <div class="main-slider__slide-content__logo">
                                    <picture>
                                        <source media="(min-width: 992px)" srcset="https://pic.honeytoon.com/uploads/s31-single/1b07f2f3-5a94-4637-8da9-21d189d564ab-1727797596-42.webp">
                                        <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/56016a3c-89c8-4b69-89b0-3df009cdf0cc-1727797592-53.webp" class="main-slider__slide-content__logo" alt="Image">
                                    </picture>
                                                                                                        </div>
                                                                    <div class="main-slider__slide-content__labels label">
                                                                                    <span class="label__item label__item--cheating" style="background-color: #ffff99;">Cheating</span>
                                                                                    <span class="label__item label__item--harem" style="background-color: #81d41c;">Harem</span>
                                                                            </div>
                                                                <p class="main-slider__slide-content__desc">
                                    When Noah, a struggling web novelist, finds himself in an unexpected marriage with Jane, one of three sisters who once tormented him, his life takes a chaotic turn. As Jane is sent overseas for work, her empty home becomes a playground for her two sisters— Lisa, a sultry divorcee, and Emily, a bold college student. The odd cohabitation stirs unexpected emotions as Noah is torn between Jane&#039;s provocative allure and Emily&#039;s carefree spirit. As old feelings resurface and new temptations arise, Noah is caught in a tangled web of desire, guilt, and forbidden attraction. Will he find clarity amidst the chaos, or will he be forever trapped between the two sisters?
                                </p>
                                <div class="main-slider__slide-content__btns btn-wrap">
                                    <a href="comic/three-sisters/prologue.html" class="btn btn-yellow">
                                        Read now
                                    </a>
                                </div>
                            </div>
                        </div>

                    
                
                    
                        <div class="main-slider__slide swiper-slide" onclick="window.location.assign('/comic/winter-games')" style="background: #022800;">
                            <picture>
                                <source media="(min-width: 768px)"  srcset="https://pic.honeytoon.com/uploads/s31-single/1ef44ad4-6554-421b-a364-5cf9ff769f8c-1734600128-56.webp">
                                <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/b8c220af-d691-49db-8519-d8329eb5b4c1-1734600123-83.webp" class="main-slider__slide-bg" alt="Image">
                            </picture>
                                                                                    <div class="main-slider__slide-content">
                                <div class="main-slider__slide-content__logo">
                                    <picture>
                                        <source media="(min-width: 992px)" srcset="https://pic.honeytoon.com/uploads/s31-single/621adddb-0d07-4c13-bcf0-376b68c27ee2-1716221886-68.webp">
                                        <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/831261dd-a31a-42c0-9f19-df619d74c705-1716221882-37.webp" class="main-slider__slide-content__logo" alt="Image">
                                    </picture>
                                                                                                        </div>
                                                                    <div class="main-slider__slide-content__labels label">
                                                                                    <span class="label__item label__item--in-law" style="background-color: #ffc68c;">In-Law</span>
                                                                                    <span class="label__item label__item--harem" style="background-color: #81d41c;">Harem</span>
                                                                            </div>
                                                                <p class="main-slider__slide-content__desc">
                                    Step-siblings Jeff and Sam head to a cozy ski resort for a Christmas getaway with her two childhood friends, Stacy and Amanda—women Jeff remembers as his babysitters. Surrounded by confident, captivating company, Jeff soon finds himself caught in unexpected tension. Stacy is bold and flirty, while Amanda’s quiet affection stirs something deeper. Can those winter games by the fireplace brake boundaries between step-siblings?
                                </p>
                                <div class="main-slider__slide-content__btns btn-wrap">
                                    <a href="comic/winter-games/prologue.html" class="btn btn-yellow">
                                        Read now
                                    </a>
                                </div>
                            </div>
                        </div>

                    
                
                    
                        <div class="main-slider__slide swiper-slide" onclick="window.location.assign('/comic/private-tutor')" style="background: #190320;">
                            <picture>
                                <source media="(min-width: 768px)"  srcset="https://pic.honeytoon.com/uploads/s31-single/cef3ab1e-fb1b-4d6b-89fd-ec8a8da36403-1738695213-96.webp">
                                <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/de89b777-25aa-4a82-9979-0404785ae7a3-1738695205-19.webp" class="main-slider__slide-bg" alt="Image">
                            </picture>
                                                                                    <div class="main-slider__slide-content">
                                <div class="main-slider__slide-content__logo">
                                    <picture>
                                        <source media="(min-width: 992px)" srcset="https://pic.honeytoon.com/uploads/s31-single/14ec99f1-4002-492f-b0d7-15ba8357292c-1716221935-89.webp">
                                        <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/c7d8b8b5-0d92-4d89-8d0c-91179fb06b07-1716221932-30.webp" class="main-slider__slide-content__logo" alt="Image">
                                    </picture>
                                                                                                        </div>
                                                                    <div class="main-slider__slide-content__labels label">
                                                                                    <span class="label__item label__item--romance" style="background-color: #ff80bd;">Romance</span>
                                                                            </div>
                                                                <p class="main-slider__slide-content__desc">
                                    Young Mr. Sunghoon is getting ready for entrance exams at a prestigious University. His parents hired a private tutor for him. Will this beautiful lady teacher find a special and efficient motivation for her 20-year-old virgin student?
                                </p>
                                <div class="main-slider__slide-content__btns btn-wrap">
                                    <a href="comic/private-tutor/prologue.html" class="btn btn-yellow">
                                        Read now
                                    </a>
                                </div>
                            </div>
                        </div>

                    
                
                    
                        <div class="main-slider__slide swiper-slide" onclick="window.location.assign('/comic/girl-next-door')" style="background: #69c0f7;">
                            <picture>
                                <source media="(min-width: 768px)"  srcset="https://pic.honeytoon.com/uploads/s31-single/9977738c-85c8-42dd-acb7-2f7ce762d2f5-1738837731-41.webp">
                                <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/a79a0da8-d355-4f16-9628-b80ea9a3dab0-1738837726-52.webp" class="main-slider__slide-bg" alt="Image">
                            </picture>
                                                                                    <div class="main-slider__slide-content">
                                <div class="main-slider__slide-content__logo">
                                    <picture>
                                        <source media="(min-width: 992px)" srcset="https://pic.honeytoon.com/uploads/s31-single/81a02459-cf2c-4ead-b03b-5f177269153d-1734600198-28.webp">
                                        <img width="200" height="200" src="https://pic.honeytoon.com/uploads/s31-single/6849ed17-27fc-4bd7-b939-5a6038999a11-1730198902-96.webp" class="main-slider__slide-content__logo" alt="Image">
                                    </picture>
                                                                                                        </div>
                                                                    <div class="main-slider__slide-content__labels label">
                                                                                    <span class="label__item label__item--college" style="background-color: #9896ff;">College</span>
                                                                                    <span class="label__item label__item--harem" style="background-color: #81d41c;">Harem</span>
                                                                            </div>
                                                                <p class="main-slider__slide-content__desc">
                                    Mike has always prioritized studying over relationships. He rarely notices girls, and they don’t pay much attention to him either. But when a nice girl from abroad moves into an apartment next door, everything changes.
                                </p>
                                <div class="main-slider__slide-content__btns btn-wrap">
                                    <a href="comic/girl-next-door/prologue.html" class="btn btn-yellow">
                                        Read now
                                    </a>
                                </div>
                            </div>
                        </div>

                    
                            </div>
            <div class="main-slider-pagination swiper-pagination"></div>

            <div class="swiper-button-next main-slider-control main-slider-control-next">
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M10.9766 10.0006L6.85156 5.8756L8.0299 4.69727L13.3332 10.0006L8.0299 15.3039L6.85156 14.1256L10.9766 10.0006Z" fill="black"/>
                </svg>
            </div>
            <div class="swiper-button-prev main-slider-control main-slider-control-prev">
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9.02268 10.0006L13.1477 14.1256L11.9693 15.3039L6.66602 10.0006L11.9693 4.69727L13.1477 5.8756L9.02268 10.0006Z" fill="black"/>
                </svg>
            </div>
        </div>
    </section>
        
    
        
                    <section class="section section-continue-reading" data-placement="continue-reading">
    <div class="container">
        <div class="section-head">
            <h2 class="section__title">Continue reading</h2>
            <a href="mylibrary.html" class="section__button btn hide-d-md">
                My Library
                <svg class="btn-icon btn-icon--after" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M13.4773 9.16591L9.00732 4.69591L10.1857 3.51758L16.6673 9.99924L10.1857 16.4809L9.00732 15.3026L13.4773 10.8326H3.33398V9.16591H13.4773Z" fill="#000000"/>
                </svg>
            </a>
        </div>
        <div class="card-wrapper">
            <div class="card-inner scrolling-wrapper">
                                                    



<div class="preview-card skeleton "
     data-comic-id="239"
     data-comic-episodes-count="52"
     data-order-date="-1671546358"
     data-is-eighteen="1"
              data-order-rating="-40"
     >

    
    <a href="comic/taste-of-stealing-physical-charity.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"taste-of-stealing-physical-charity",
     "id":"239",
     "title":"Taste of Stealing Physical Charity"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/2621e118-77e2-45c8-b247-07d5f9f4d400-1689092306-89.webp" alt="Taste of Stealing Physical Charity"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/2621e118-77e2-45c8-b247-07d5f9f4d400-1689092306-89.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4/5</span>
            </div>
            
            <span class="preview-card__title">
                Taste of Stealing Physical Charity
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--romance"
                              style=" color: #ff80bd;">
                                Romance
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">52</span>
    </a>
    </div>                                    



<div class="preview-card skeleton "
     data-comic-id="860"
     data-comic-episodes-count="22"
     data-order-date="-1742214225"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/dream-vacation/12.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"dream-vacation",
     "id":"860",
     "title":"Dream Vacation"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/4e20c01e-cc3e-4067-a38f-20a9c197c46e-1742215873-88.webp" alt="Dream Vacation"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/4e20c01e-cc3e-4067-a38f-20a9c197c46e-1742215873-88.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Dream Vacation
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--romance"
                              style=" color: #ff80bd;">
                                Romance
                            </span>
                                            <span class="preview-card__category-item category__item category__item--drama"
                              style=" color: #97c256;">
                                Drama
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">12</span>
    </a>
    </div>                                    



<div class="preview-card skeleton "
     data-comic-id="814"
     data-comic-episodes-count="21"
     data-order-date="-1737711815"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/lesson-s/18.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"lesson-s",
     "id":"814",
     "title":"Lesson S"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/7fc1e777-ee76-4f47-8f49-513103d193a5-1737713911-96.webp" alt="Lesson S"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/7fc1e777-ee76-4f47-8f49-513103d193a5-1737713911-96.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Lesson S
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">18</span>
    </a>
    </div>                                    



<div class="preview-card skeleton "
     data-comic-id="753"
     data-comic-episodes-count="51"
     data-order-date="-1732526109"
     data-is-eighteen="1"
              data-order-rating="-47"
     >

    
    <a href="comic/high-class-person/26.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"high-class-person",
     "id":"753",
     "title":"High-Class Person"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/641bb9f7-5d78-451a-a562-da8598b8e95c-1732526320-55.webp" alt="High-Class Person"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/641bb9f7-5d78-451a-a562-da8598b8e95c-1732526320-55.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.7/5</span>
            </div>
            
            <span class="preview-card__title">
                High-Class Person
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--college"
                              style=" color: #9896ff;">
                                College
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">26</span>
    </a>
    </div>                                    



<div class="preview-card skeleton "
     data-comic-id="833"
     data-comic-episodes-count="20"
     data-order-date="-1740731330"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/trapped-in-an-elevator/12.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"trapped-in-an-elevator",
     "id":"833",
     "title":"Trapped In An Elevator"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/6bb87710-455e-4a3d-8f1c-9297764631fa-1740731423-80.webp" alt="Trapped In An Elevator"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/6bb87710-455e-4a3d-8f1c-9297764631fa-1740731423-80.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Trapped In An Elevator
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">12</span>
    </a>
    </div>                                    



<div class="preview-card skeleton "
     data-comic-id="855"
     data-comic-episodes-count="26"
     data-order-date="-1741686963"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/trapped-in-the-cabin/13.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"trapped-in-the-cabin",
     "id":"855",
     "title":"Trapped In The Cabin"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/85d7deb5-bfe4-4d69-9818-f2c325474cbe-1741687108-91.webp" alt="Trapped In The Cabin"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/85d7deb5-bfe4-4d69-9818-f2c325474cbe-1741687108-91.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Trapped In The Cabin
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">13</span>
    </a>
    </div>                
                <div class="preview-card preview-card-default">
                    <div class="preview-card-default-content">
                        <span class="preview-card-default__title">Read Something New</span>
                        <a href="new.html" class="btn btn-primary-small--white">
                            Read now
                            <svg class="btn-icon btn-icon--after" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M13.4773 9.16591L9.00732 4.69591L10.1857 3.51758L16.6673 9.99924L10.1857 16.4809L9.00732 15.3026L13.4773 10.8326H3.33398V9.16591H13.4773Z" fill="white"/>
                            </svg>
                        </a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
        
    
        
        
    
        
        
    
        
                    <section class="section section-something" data-placement="">
    <div class="container">
        <div class="section-head">
                        <h2 class="section__title">Popular</h2>
                    </div>

                                    
        <div class="card-wrapper">
            <div class="card-inner card-inner-grid card-inner-grid--six">
                                                                            



<div class="preview-card skeleton "
     data-comic-id="431"
     data-comic-episodes-count="53"
     data-order-date="-1707836872"
     data-is-eighteen="1"
              data-order-rating="-48"
     >

    
    <a href="comic/exclusive-club.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"exclusive-club",
     "id":"431",
     "title":"Exclusive Club"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/e4f9d3e2-5b45-4c39-bc59-17fd05ff5940-1715873074-59.webp" alt="Exclusive Club"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/e4f9d3e2-5b45-4c39-bc59-17fd05ff5940-1715873074-59.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.8/5</span>
            </div>
            
            <span class="preview-card__title">
                Exclusive Club
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">52</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="296"
     data-comic-episodes-count="16"
     data-order-date="-1696427367"
     data-is-eighteen="1"
              data-order-rating="-47"
     >

    
    <a href="comic/vacation-with-my-stepmom.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"vacation-with-my-stepmom",
     "id":"296",
     "title":"Vacation With My Stepmom"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/fd378d55-19c8-41ec-844d-aab9fa040aca-1715873111-91.webp" alt="Vacation With My Stepmom"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/fd378d55-19c8-41ec-844d-aab9fa040aca-1715873111-91.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.7/5</span>
            </div>
            
            <span class="preview-card__title">
                Vacation With My Stepmom
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--romance"
                              style=" color: #ff80bd;">
                                Romance
                            </span>
                                            <span class="preview-card__category-item category__item category__item--milf"
                              style=" color: #cb6cc8;">
                                MILF
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">15</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="691"
     data-comic-episodes-count="52"
     data-order-date="-1727285896"
     data-is-eighteen="1"
              data-order-rating="-50"
     >

    
    <a href="comic/dont-call-me-stepmom.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"dont-call-me-stepmom",
     "id":"691",
     "title":"Don’t Call Me Stepmom"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/ff97f027-75e2-47d3-bbe2-248123f6a94b-1739721589-73.webp" alt="Don’t Call Me Stepmom"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/ff97f027-75e2-47d3-bbe2-248123f6a94b-1739721589-73.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>5/5</span>
            </div>
            
            <span class="preview-card__title">
                Don’t Call Me Stepmom
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--in-law"
                              style=" color: #ffc68c;">
                                In-Law
                            </span>
                                            <span class="preview-card__category-item category__item category__item--milf"
                              style=" color: #cb6cc8;">
                                MILF
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">51</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="276"
     data-comic-episodes-count="32"
     data-order-date="-1687873384"
     data-is-eighteen="1"
              data-order-rating="-48"
     >

    
    <a href="comic/midsummer-nights-dream/31.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"midsummer-nights-dream",
     "id":"276",
     "title":"Midsummer Nights Dream"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/cef50013-b415-4d3d-8f77-b3506f737d7b-1715873187-56.webp" alt="Midsummer Nights Dream"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/cef50013-b415-4d3d-8f77-b3506f737d7b-1715873187-56.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.8/5</span>
            </div>
            
            <span class="preview-card__title">
                Midsummer Nights Dream
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--romance"
                              style=" color: #ff80bd;">
                                Romance
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">31</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="212"
     data-comic-episodes-count="66"
     data-order-date="-1669717477"
     data-is-eighteen="1"
              data-order-rating="-47"
     >

    
    <a href="comic/shh-sisters-secret.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"shh-sisters-secret",
     "id":"212",
     "title":"Shh! Sister&#039;s Secret"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/bf78d192-cb71-4f22-ba1b-0586ad0179c0-1715873247-12.webp" alt="Shh! Sister&#039;s Secret"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/bf78d192-cb71-4f22-ba1b-0586ad0179c0-1715873247-12.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.7/5</span>
            </div>
            
            <span class="preview-card__title">
                Shh! Sister&#039;s Secret
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--in-law"
                              style=" color: #ffc68c;">
                                In-Law
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">65</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="293"
     data-comic-episodes-count="51"
     data-order-date="-1695970519"
     data-is-eighteen="1"
              data-order-rating="-48"
     >

    
    <a href="comic/my-stepmom-is-my-girlfriend.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"my-stepmom-is-my-girlfriend",
     "id":"293",
     "title":"My Stepmom is my Girlfriend"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/2e6b64f2-3cae-42ea-a829-75e06f44834b-1715873283-95.webp" alt="My Stepmom is my Girlfriend"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/2e6b64f2-3cae-42ea-a829-75e06f44834b-1715873283-95.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.8/5</span>
            </div>
            
            <span class="preview-card__title">
                My Stepmom is my Girlfriend
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--in-law"
                              style=" color: #ffc68c;">
                                In-Law
                            </span>
                                            <span class="preview-card__category-item category__item category__item--milf"
                              style=" color: #cb6cc8;">
                                MILF
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">50</span>
    </a>
    </div>                            </div>
                    </div>
    </div>
    </section>        
    
        
                        <section class="top-fifth-manga-section">
        <div class="container">
            <div class="top-fifth-manga">

                
                <div class="top-fifth-manga-head">
                    <h2 class="top-fifth-manga__title">
                        Trending Manga
                                                    <span class="top-fifth-manga__title-label">NEW</span>
                                            </h2>
                                    </div>
                <div class="top-fifth-manga-inner">
                    <div class="swiper top-fifth-manga-slider">
                        <div class="swiper-wrapper top-fifth-manga-wrapper">
                                                            <div class="swiper-slide preview-card"
                                     data-comic-id="892"
                                     data-comic-episodes-count="63"
                                     data-order-date="-1743422074"
                                     data-is-eighteen="1"
                                     data-order-rating="-0"
                                >
                                    <a href="manga/you-can-grope-it-if-only-10-times.html" class="preview-card__link">

                                        <img class="preview-card__image" src="https://pic.honeytoon.com/uploads/s31-single/764c83c4-dc8d-431d-b97a-9e33c4f30cdb-1743422147-93.webp" alt="You Can Grope It If Only 10 Times" >
                                        <span class="preview-card__image-size"></span>

                                        <div class="preview-card__labels label eighteen">
                                                                                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                                                                                            <span class="preview-card__labels-item label__item label__item--manga">manga</span>                                                                                    </div>

                                        <div class="preview-card__body">
                                            
                                            <span class="preview-card__title">You Can Grope It If Only 10 Times</span>

                                                                                            <div class="preview-card__category category">
                                                                                                            <span class="preview-card__category-item category__item category__item--cheating"
                                                              style=" color: #ffff99;">Cheating</span>
                                                                                                            <span class="preview-card__category-item category__item category__item--harem"
                                                              style=" color: #81d41c;">Harem</span>
                                                                                                    </div>
                                                                                    </div>

                                        <span class="preview-card__episodes-count">63</span>
                                    </a>
                                                                    </div>
                                                            <div class="swiper-slide preview-card"
                                     data-comic-id="885"
                                     data-comic-episodes-count="22"
                                     data-order-date="-1743410337"
                                     data-is-eighteen="1"
                                     data-order-rating="-0"
                                >
                                    <a href="manga/ntr-sex-wars.html" class="preview-card__link">

                                        <img class="preview-card__image" src="https://pic.honeytoon.com/uploads/s31-single/74b3d27d-1c07-4f67-afce-399c926dc3ba-1743411113-37.webp" alt="N.T.R Sex Wars" >
                                        <span class="preview-card__image-size"></span>

                                        <div class="preview-card__labels label eighteen">
                                                                                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                                                                                            <span class="preview-card__labels-item label__item label__item--manga">manga</span>                                                                                    </div>

                                        <div class="preview-card__body">
                                            
                                            <span class="preview-card__title">N.T.R Sex Wars</span>

                                                                                            <div class="preview-card__category category">
                                                                                                            <span class="preview-card__category-item category__item category__item--cheating"
                                                              style=" color: #ffff99;">Cheating</span>
                                                                                                    </div>
                                                                                    </div>

                                        <span class="preview-card__episodes-count">22</span>
                                    </a>
                                                                    </div>
                                                            <div class="swiper-slide preview-card"
                                     data-comic-id="891"
                                     data-comic-episodes-count="45"
                                     data-order-date="-1743418834"
                                     data-is-eighteen="1"
                                     data-order-rating="-0"
                                >
                                    <a href="manga/stealthily-fucking-my-dozing-boss.html" class="preview-card__link">

                                        <img class="preview-card__image" src="https://pic.honeytoon.com/uploads/s31-single/bb6ce3be-2d46-4659-9781-880b9b26796b-1743418928-51.webp" alt="Stealthily Fucking My Dozing Boss" >
                                        <span class="preview-card__image-size"></span>

                                        <div class="preview-card__labels label eighteen">
                                                                                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                                                                                            <span class="preview-card__labels-item label__item label__item--manga">manga</span>                                                                                    </div>

                                        <div class="preview-card__body">
                                            
                                            <span class="preview-card__title">Stealthily Fucking My Dozing Boss</span>

                                                                                            <div class="preview-card__category category">
                                                                                                            <span class="preview-card__category-item category__item category__item--cheating"
                                                              style=" color: #ffff99;">Cheating</span>
                                                                                                    </div>
                                                                                    </div>

                                        <span class="preview-card__episodes-count">45</span>
                                    </a>
                                                                    </div>
                                                            <div class="swiper-slide preview-card"
                                     data-comic-id="890"
                                     data-comic-episodes-count="36"
                                     data-order-date="-1743415189"
                                     data-is-eighteen="1"
                                     data-order-rating="-0"
                                >
                                    <a href="manga/an-old-mans-convincing-sex.html" class="preview-card__link">

                                        <img class="preview-card__image" src="https://pic.honeytoon.com/uploads/s31-single/565b5851-e856-4f08-a1c9-e456a66dfed9-1743415237-14.webp" alt="An Old Man’s Convincing Sex" >
                                        <span class="preview-card__image-size"></span>

                                        <div class="preview-card__labels label eighteen">
                                                                                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                                                                                            <span class="preview-card__labels-item label__item label__item--manga">manga</span>                                                                                    </div>

                                        <div class="preview-card__body">
                                            
                                            <span class="preview-card__title">An Old Man’s Convincing Sex</span>

                                                                                            <div class="preview-card__category category">
                                                                                                            <span class="preview-card__category-item category__item category__item--cheating"
                                                              style=" color: #ffff99;">Cheating</span>
                                                                                                    </div>
                                                                                    </div>

                                        <span class="preview-card__episodes-count">36</span>
                                    </a>
                                                                    </div>
                                                            <div class="swiper-slide preview-card"
                                     data-comic-id="880"
                                     data-comic-episodes-count="36"
                                     data-order-date="-1743171703"
                                     data-is-eighteen="1"
                                     data-order-rating="-0"
                                >
                                    <a href="manga/forced-to-have-sex-for-a-week.html" class="preview-card__link">

                                        <img class="preview-card__image" src="https://pic.honeytoon.com/uploads/s31-single/19f69ed8-e18d-43de-9420-1fcf0ae65a3c-1743171994-86.webp" alt="Forced To Have Sex For A Week" >
                                        <span class="preview-card__image-size"></span>

                                        <div class="preview-card__labels label eighteen">
                                                                                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                                                                                            <span class="preview-card__labels-item label__item label__item--manga">manga</span>                                                                                    </div>

                                        <div class="preview-card__body">
                                            
                                            <span class="preview-card__title">Forced To Have Sex For A Week</span>

                                                                                            <div class="preview-card__category category">
                                                                                                            <span class="preview-card__category-item category__item category__item--cheating"
                                                              style=" color: #ffff99;">Cheating</span>
                                                                                                            <span class="preview-card__category-item category__item category__item--harem"
                                                              style=" color: #81d41c;">Harem</span>
                                                                                                    </div>
                                                                                    </div>

                                        <span class="preview-card__episodes-count">36</span>
                                    </a>
                                                                    </div>
                                                    </div>
                        <div class="top-fifth-manga-slider-pagination swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
        
    
        
                    <section class="section section-something" data-placement="">
    <div class="container">
        <div class="section-head">
                        <h2 class="section__title">Something New</h2>
                    </div>

                                    
        <div class="card-wrapper">
            <div class="card-inner card-inner-grid card-inner-grid--six">
                                                                            



<div class="preview-card skeleton "
     data-comic-id="855"
     data-comic-episodes-count="26"
     data-order-date="-1741686963"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/trapped-in-the-cabin/13.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"trapped-in-the-cabin",
     "id":"855",
     "title":"Trapped In The Cabin"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/36ddae3e-a020-4ef9-b5fa-b99e7168b1e1-1741765445-59.webp" alt="Trapped In The Cabin"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/36ddae3e-a020-4ef9-b5fa-b99e7168b1e1-1741765445-59.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Trapped In The Cabin
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">13</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="860"
     data-comic-episodes-count="22"
     data-order-date="-1742214225"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/dream-vacation/12.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"dream-vacation",
     "id":"860",
     "title":"Dream Vacation"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/243f4103-dbf0-4a8f-b41a-39aa7d1dfad2-1742218214-45.webp" alt="Dream Vacation"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/243f4103-dbf0-4a8f-b41a-39aa7d1dfad2-1742218214-45.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Dream Vacation
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--romance"
                              style=" color: #ff80bd;">
                                Romance
                            </span>
                                            <span class="preview-card__category-item category__item category__item--drama"
                              style=" color: #97c256;">
                                Drama
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">12</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="836"
     data-comic-episodes-count="20"
     data-order-date="-1740733750"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/stranger-in-my-bathroom/12.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"stranger-in-my-bathroom",
     "id":"836",
     "title":"Stranger in my bathroom"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/f88984c7-1c77-4fde-ac55-3b578761d1ea-1740738447-69.webp" alt="Stranger in my bathroom"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/f88984c7-1c77-4fde-ac55-3b578761d1ea-1740738447-69.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Stranger in my bathroom
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">12</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="838"
     data-comic-episodes-count="22"
     data-order-date="-1740735026"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/wax-me-boss/12.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"wax-me-boss",
     "id":"838",
     "title":"Wax Me, Boss"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/2cb6a612-17aa-4c6e-8671-18b49a46e4ca-1741081653-85.webp" alt="Wax Me, Boss"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/2cb6a612-17aa-4c6e-8671-18b49a46e4ca-1741081653-85.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Wax Me, Boss
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--business"
                              style=" color: #fff15c;">
                                Business
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">12</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="833"
     data-comic-episodes-count="20"
     data-order-date="-1740731330"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/trapped-in-an-elevator/12.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"trapped-in-an-elevator",
     "id":"833",
     "title":"Trapped In An Elevator"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/5387d5d3-d3fc-4cb2-bcc7-bb989d0cbe4b-1740738517-54.webp" alt="Trapped In An Elevator"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/5387d5d3-d3fc-4cb2-bcc7-bb989d0cbe4b-1740738517-54.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Trapped In An Elevator
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">12</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="835"
     data-comic-episodes-count="13"
     data-order-date="-1740732970"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/text-me-now/12.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"text-me-now",
     "id":"835",
     "title":"Text Me. NOW!"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/e679d26d-a5e9-4058-9738-f1d758ad13c3-1740738565-53.webp" alt="Text Me. NOW!"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/e679d26d-a5e9-4058-9738-f1d758ad13c3-1740738565-53.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Text Me. NOW!
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">12</span>
    </a>
    </div>                            </div>
                    </div>
    </div>
    </section>        
    
        
                    
    <section class="section banner banner-chapter" data-placement="">
        <div class="container">
            <div class="banner-chapter-inner">
                <div class="banner-chapter-inner-content">
                    <span class="banner-chapter__under-title">You might love it</span>
                    <div class="banner-chapter__logo">
                        <picture>
                            <source media="(min-width: 768px)" srcset="https://pic.honeytoon.com/uploads/s31-single/7ac71fb4-82ae-44c2-9458-88484b6126c5-1693995153-82.webp">
                            <img width="200" height="200" data-loading="lazy" src="https://pic.honeytoon.com/uploads/s31-single/bc165b31-a111-427e-82c1-b256388a6881-1693995150-53.webp" class="banner-chapter__logo" alt="Image">
                        </picture>
                    </div>
                    <div class="banner-chapter__labels label">
                        <span class="label__item label__item--age">18+</span>                                                    <span class="label__item label__item--romance" style="background-color: #ff80bd;">Romance</span>
                                                    <span class="label__item label__item--milf" style="background-color: #cb6cc8;">MILF</span>
                                            </div>
                    <div class="banner-chapter__desc-inner">
                        <p class="banner-chapter__desc">My mom runs the flower shop. I was stunned when I knew she dates my friend Kim! What should I do?</p>
                    </div>
                    <div class="banner-chapter__btns btn-wrap">
                        <a data-banner-click="/comic/my-friends-mom/prologue"
                           href="comic/my-friends-mom/prologue.html" class="btn btn-yellow">
                            Read now
                        </a>
                        <a data-banner-click="/comic/my-friends-mom" href="comic/my-friends-mom.1.html" class="btn-transparent-link">
                            More info
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_3_38279)">
                                    <path d="M10.9766 10.0006L6.85156 5.8756L8.0299 4.69727L13.3332 10.0006L8.0299 15.3039L6.85156 14.1256L10.9766 10.0006Z" fill="white"></path>
                                </g>
                                <defs>
                                    <clipPath id="clip0_3_38279">
                                        <rect width="20" height="20" fill="white"></rect>
                                    </clipPath>
                                </defs>
                            </svg>
                        </a>
                    </div>
                </div>
                <picture class="picture-bg">
                    <source media="(min-width: 768px)" srcset="https://pic.honeytoon.com/uploads/s31-single/e20fe261-9d90-4bff-a7c3-cad2d412d1e4-1741858587-67.webp">
                    <img data-loading="lazy" width="100" height="100" src="https://pic.honeytoon.com/uploads/s31-single/b7a16cdb-646d-4b1f-a5aa-e92e1483b05d-1741857258-33.webp" class="banner-chapter__img" alt="My Friend’s Mom">
                </picture>
            </div>
        </div>
            </section>
        
    
        
                    <section class="section section-something" data-placement="">
    <div class="container">
        <div class="section-head">
                        <h2 class="section__title">Only On Honeytoon</h2>
                    </div>

                                    
        <div class="card-wrapper">
            <div class="card-inner card-inner-grid card-inner-grid--six">
                                                                            



<div class="preview-card skeleton "
     data-comic-id="680"
     data-comic-episodes-count="21"
     data-order-date="-1726468883"
     data-is-eighteen="1"
              data-order-rating="-37"
     >

    
    <a href="comic/three-sisters.1.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"three-sisters",
     "id":"680",
     "title":"Three sisters"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/22a4b593-d81c-44ce-b917-47823984c898-1730293411-12.webp" alt="Three sisters"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/22a4b593-d81c-44ce-b917-47823984c898-1730293411-12.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>3.7/5</span>
            </div>
            
            <span class="preview-card__title">
                Three sisters
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">20</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="276"
     data-comic-episodes-count="32"
     data-order-date="-1687873384"
     data-is-eighteen="1"
              data-order-rating="-48"
     >

    
    <a href="comic/midsummer-nights-dream/31.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"midsummer-nights-dream",
     "id":"276",
     "title":"Midsummer Nights Dream"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/cef50013-b415-4d3d-8f77-b3506f737d7b-1715873187-56.webp" alt="Midsummer Nights Dream"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/cef50013-b415-4d3d-8f77-b3506f737d7b-1715873187-56.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.8/5</span>
            </div>
            
            <span class="preview-card__title">
                Midsummer Nights Dream
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--romance"
                              style=" color: #ff80bd;">
                                Romance
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">31</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="763"
     data-comic-episodes-count="11"
     data-order-date="-1733473503"
     data-is-eighteen="1"
              data-order-rating="-50"
     >

    
    <a href="comic/winter-games.1.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"winter-games",
     "id":"763",
     "title":"Winter Games"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/d442d465-3e29-4ec9-a917-c7b8de9b30fc-1737013941-31.webp" alt="Winter Games"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/d442d465-3e29-4ec9-a917-c7b8de9b30fc-1737013941-31.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>5/5</span>
            </div>
            
            <span class="preview-card__title">
                Winter Games
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--in-law"
                              style=" color: #ffc68c;">
                                In-Law
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">10</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="870"
     data-comic-episodes-count="9"
     data-order-date="-1742485318"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/its-all-about-her/6.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"its-all-about-her",
     "id":"870",
     "title":"It&#039;s All About Her"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/65b14546-1b34-4512-af67-0ab2587633f5-1742556299-92.webp" alt="It&#039;s All About Her"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/65b14546-1b34-4512-af67-0ab2587633f5-1742556299-92.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                It&#039;s All About Her
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">8</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="756"
     data-comic-episodes-count="11"
     data-order-date="-1733151497"
     data-is-eighteen="1"
              data-order-rating="-49"
     >

    
    <a href="comic/stepmom-comes-first.1.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"stepmom-comes-first",
     "id":"756",
     "title":"Stepmom Comes First"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/3904b327-2832-4504-ac36-a31287ad3d6b-1737013553-97.webp" alt="Stepmom Comes First"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/3904b327-2832-4504-ac36-a31287ad3d6b-1737013553-97.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.9/5</span>
            </div>
            
            <span class="preview-card__title">
                Stepmom Comes First
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--in-law"
                              style=" color: #ffc68c;">
                                In-Law
                            </span>
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">10</span>
    </a>
    </div>                                                                            



<div class="preview-card skeleton "
     data-comic-id="818"
     data-comic-episodes-count="11"
     data-order-date="-1738593391"
     data-is-eighteen="1"
              data-order-rating="-50"
     >

    
    <a href="comic/honeymoon-with-my-mother-in-law/9.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"honeymoon-with-my-mother-in-law",
     "id":"818",
     "title":"Honeymoon With My Mother-In-Law"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/d759a6aa-3dd8-4849-bf46-ff0a0f6b0952-1738594286-68.webp" alt="Honeymoon With My Mother-In-Law"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/d759a6aa-3dd8-4849-bf46-ff0a0f6b0952-1738594286-68.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>5/5</span>
            </div>
            
            <span class="preview-card__title">
                Honeymoon With My Mother-In-Law
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--in-law"
                              style=" color: #ffc68c;">
                                In-Law
                            </span>
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">10</span>
    </a>
    </div>                            </div>
                    </div>
    </div>
    </section>        
    
        
                                <section class="section banner banner-with-image"
             data-placement=""
             data-banner-click="https://honeytoon.com/new">
        <div class="container">
            <div class="banner-inner">
                <a href="new.html" >
                    <picture>
                        <source data-ampl-event='banner_click|{"banner_type":"https://honeytoon.com/new","path":"/"}' media="(min-width: 768px)" srcset="https://pic.honeytoon.com/uploads/s31-single/95188fa9-7e78-47e0-bfef-9a4a8c911958-1733409777-39.webp">
                        <img data-ampl-event='banner_click|{"banner_type":"https://honeytoon.com/new","path":"/"}' data-loading="lazy" src="https://pic.honeytoon.com/uploads/s31-single/8af9a326-b9a2-4a01-9639-974155ef7d8b-1733409772-34.webp" class="banner-with-image__img" alt="banner">
                    </picture>
                </a>
            </div>
        </div>
            </section>
        
    
        
                    <section class="section section-something" data-placement="">
    <div class="container">
        <div class="section-head">
                        <h2 class="section__title">Uncensored exclusives</h2>
                    </div>

                                    
        <div class="card-wrapper">
            <div class="card-inner card-inner-grid card-inner-grid--six">
                                                                            
    
    
        
    
                


<div class="preview-card skeleton  uncensored-upsell-a-3  uncensored-upsell-had-tokens-0  "
     data-comic-id="613"
     data-comic-episodes-count="10"
     data-order-date="-1722428096"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/girl-next-door-full.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"girl-next-door-full",
     "id":"613",
     "title":"Girl Next Door"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/1ecac55c-6eeb-43b4-9ef8-e3f376dedce7-1735293094-62.webp" alt="Girl Next Door"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/1ecac55c-6eeb-43b4-9ef8-e3f376dedce7-1735293094-62.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--uncensored">Uncensored</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Girl Next Door
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--college"
                              style=" color: #9896ff;">
                                College
                            </span>
                                            <span class="preview-card__category-item category__item category__item--uncensored"
                              style="order: -9999; color: #ff0000;">
                                Uncensored
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">10</span>
    </a>
    </div>                                                                            
    
    
        
    
                


<div class="preview-card skeleton  uncensored-upsell-a-3  uncensored-upsell-had-tokens-0  "
     data-comic-id="825"
     data-comic-episodes-count="20"
     data-order-date="-1739367504"
     data-is-eighteen="1"
              data-order-rating="-48"
     >

    
    <a href="comic/the-unwanted-roommate-full/17.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"the-unwanted-roommate-full",
     "id":"825",
     "title":"The Unwanted Roommate"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/b8857023-c18f-4e78-a3d2-7551e71b9fda-1739368637-27.webp" alt="The Unwanted Roommate"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/b8857023-c18f-4e78-a3d2-7551e71b9fda-1739368637-27.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--uncensored">Uncensored</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.8/5</span>
            </div>
            
            <span class="preview-card__title">
                The Unwanted Roommate
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--romance"
                              style=" color: #ff80bd;">
                                Romance
                            </span>
                                            <span class="preview-card__category-item category__item category__item--uncensored"
                              style="order: -9999; color: #ff0000;">
                                Uncensored
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">17</span>
    </a>
    </div>                                                                            
    
    
        
    
                


<div class="preview-card skeleton  uncensored-upsell-a-3  uncensored-upsell-had-tokens-0  "
     data-comic-id="827"
     data-comic-episodes-count="12"
     data-order-date="-1739548221"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/prank-goes-wrong-full.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"prank-goes-wrong-full",
     "id":"827",
     "title":"Prank Goes Wrong"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/5eb5e7b1-aa9b-4f45-b210-14d304641283-1739548698-51.webp" alt="Prank Goes Wrong"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/5eb5e7b1-aa9b-4f45-b210-14d304641283-1739548698-51.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--uncensored">Uncensored</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Prank Goes Wrong
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--in-law"
                              style=" color: #ffc68c;">
                                In-Law
                            </span>
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--uncensored"
                              style="order: -9999; color: #ff0000;">
                                Uncensored
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">11</span>
    </a>
    </div>                                                                            
    
    
        
    
                


<div class="preview-card skeleton  uncensored-upsell-a-3  uncensored-upsell-had-tokens-0  "
     data-comic-id="770"
     data-comic-episodes-count="11"
     data-order-date="-1734429547"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/winter-games-full.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"winter-games-full",
     "id":"770",
     "title":"Winter Games"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/91fe2dba-9bc4-48d7-9139-36da28ed42df-1735293190-70.webp" alt="Winter Games"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/91fe2dba-9bc4-48d7-9139-36da28ed42df-1735293190-70.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--uncensored">Uncensored</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Winter Games
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--in-law"
                              style=" color: #ffc68c;">
                                In-Law
                            </span>
                                            <span class="preview-card__category-item category__item category__item--uncensored"
                              style="order: -9999; color: #ff0000;">
                                Uncensored
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">10</span>
    </a>
    </div>                                                                            
    
    
        
    
                


<div class="preview-card skeleton  uncensored-upsell-a-3  uncensored-upsell-had-tokens-0  "
     data-comic-id="283"
     data-comic-episodes-count="26"
     data-order-date="-1694417767"
     data-is-eighteen="1"
              data-order-rating="-45"
     >

    
    <a href="comic/daughter-in-law-full.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"daughter-in-law-full",
     "id":"283",
     "title":"Daughter in Law"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/322e6c3b-e16b-4f06-a663-f48f5ee5b9df-1735293131-67.webp" alt="Daughter in Law"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/322e6c3b-e16b-4f06-a663-f48f5ee5b9df-1735293131-67.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--uncensored">Uncensored</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
                        <div class="preview-card__rating">
                <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10 10" fill="none">
    <path d="M4.99998 0.208344L6.76082 2.78459L9.7554 3.66334L7.84915 6.13418L7.93873 9.25334L4.99998 8.20418L2.06123 9.25334L2.15082 6.13418L0.244568 3.66334L3.23915 2.78459L4.99998 0.208344ZM4.16665 5.00001H3.33332C3.33331 5.43482 3.50323 5.85243 3.80682 6.16371C4.11041 6.47499 4.52363 6.65531 4.95831 6.66618C5.39298 6.67706 5.8147 6.51763 6.13347 6.22191C6.45225 5.9262 6.64283 5.51761 6.66457 5.08334L6.66665 5.00001H5.83332C5.83429 5.21625 5.75116 5.4244 5.60149 5.58049C5.45183 5.73658 5.24735 5.82837 5.03126 5.83649C4.81517 5.8446 4.60438 5.76839 4.44344 5.62397C4.28249 5.47955 4.18399 5.27822 4.16873 5.06251L4.16665 5.00001Z" fill="#FFDB26"/>
</svg>                <span>4.5/5</span>
            </div>
            
            <span class="preview-card__title">
                Daughter in Law
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--uncensored"
                              style="order: -9999; color: #ff0000;">
                                Uncensored
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">26</span>
    </a>
    </div>                                                                            
    
    
        
    
                


<div class="preview-card skeleton  uncensored-upsell-a-3  uncensored-upsell-had-tokens-0  "
     data-comic-id="614"
     data-comic-episodes-count="11"
     data-order-date="-1722429901"
     data-is-eighteen="1"
              data-order-rating="-0"
     >

    
    <a href="comic/wonder-splash-full.html"
       data-ampl-event='comic_click|{
     "component":"preview-card",
     "path":"/",
     "comic":"wonder-splash-full",
     "id":"614",
     "title":"Wonder Splash"
     }'
       class="preview-card__link">

                
                                            <img data-loading="lazy" class="preview-card__image"
                                         src="https://pic.honeytoon.com/uploads/s31-single/6b6b51ed-c81d-4f0e-a851-94742bec27b8-1735293109-32.webp" alt="Wonder Splash"
                                         srcset="https://pic.honeytoon.com/uploads/s31-single/6b6b51ed-c81d-4f0e-a851-94742bec27b8-1735293109-32.webp"
        />

        <span class="preview-card__image-size"></span>

        <div class="preview-card__labels label eighteen">
                            <span class="preview-card__labels-item label__item label__item--age">18+</span>                            <span class="preview-card__labels-item label__item label__item--uncensored">Uncensored</span>                            <span class="preview-card__labels-item label__item label__item--complete">
    <span>END</span>
</span>                    </div>

        
        <div class="preview-card__body">
            
            <span class="preview-card__title">
                Wonder Splash
            </span>

                            <div class="preview-card__category category">
                                            <span class="preview-card__category-item category__item category__item--cheating"
                              style=" color: #ffff99;">
                                Cheating
                            </span>
                                            <span class="preview-card__category-item category__item category__item--uncensored"
                              style="order: -9999; color: #ff0000;">
                                Uncensored
                            </span>
                                            <span class="preview-card__category-item category__item category__item--harem"
                              style=" color: #81d41c;">
                                Harem
                            </span>
                                    </div>
                    </div>

        <span class="preview-card__episodes-count">11</span>
    </a>
    </div>                            </div>
                    </div>
    </div>
    </section>        
    
    </main>

    <span data-on-load-ampl-event='page_view|{"path":"/","previous_path":""}'></span>

        <div class="modal-v2 modal-trustpilot modal-trustpilot-evaluation-form  " id="trustpilot-evaluation-form-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-v2-content">

        <span class="close close-modal modal-exit">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                          fill="black"/>
                </svg>
            </span>

        <div class="modal-v2-body">

            <div class="modal-v2-inner">
                <img src="build/images/logo/logo-color.svg" class="logo" alt="logo" />
                <p class="title">Do you enjoy using Honeytoon?</p>

                <button data-p-event="trustpilot_feedback_submit" data-c-event='evaluation_form_score|{"property":"high"}' data-modal="trustpilot-trustpilot-modal" class="btn w-100 btn-white">❤️ Love it! It&#039;s amazing</button>
                <button data-p-event="trustpilot_feedback_submit" data-c-event='evaluation_form_score|{"property":"medium"}' data-modal="trustpilot-trustpilot-modal" class="btn w-100 btn-white">👌 Pretty good overall</button>
                <button data-p-event="trustpilot_feedback_submit" data-c-event='evaluation_form_score|{"property":"low"}' data-modal="trustpilot-negavite-feedback-form-modal" class="btn w-100 btn-white">🤔 Could be better</button>
            </div>

        </div>
    </div>
</div>    <div class="modal-v2 modal-trustpilot modal-trustpilot-negavite-feedback-form " id="trustpilot-negavite-feedback-form-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-v2-content">

        <span class="close close-modal modal-exit">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                          fill="black"/>
                </svg>
            </span>

        <div class="modal-v2-body">

            <div class="modal-v2-inner">
                <img src="build/images/logo/logo-color.svg" class="logo" alt="logo" />
                <p class="title">What can we improve?</p>
                <p class="text">We’re sorry to hear that! Please share your thoughts so we can make the site better for you.</p>

                <form action="comic/the-head-of-a-womens-association.html">
                    <textarea name="feedback" rows="4" class="w-100" cols="50" placeholder="Your review matters! Share your thoughts here..."></textarea>
                    <button class="btn btn-yellow btn-yellow--big w-100" type="submit">Send Feedback</button>
                </form>

            </div>

        </div>
    </div>
</div>    <div class="modal-v2 modal-trustpilot modal-trustpilot-thanks" id="trustpilot-thanks-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-v2-content">

        <span class="close close-modal modal-exit">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                          fill="black"/>
                </svg>
            </span>

        <div class="modal-v2-body">

            <div class="modal-v2-inner">
                <img src="build/images/logo/logo-color.svg" class="logo" alt="logo" />
                <p class="title">Thank You for Your Feedback! 🙏</p>
                <p class="text">Thanks for being a part of Honeytoon. Your feedback helps us grow and create the best experience for you!</p>

                <button class="btn btn-yellow btn-yellow--big w-100 modal-exit" type="button">
                    Ok
                </button>
            </div>

        </div>
    </div>
</div>    <div class="modal-v2 modal-trustpilot modal-trustpilot-trustpilot "
     data-at-appear-p-event="trustpilot_feedback_submit"
     id="trustpilot-trustpilot-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-v2-content">

        <span class="close close-modal modal-exit">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                          fill="black"/>
                </svg>
            </span>

        <div class="modal-v2-body">

            <div class="modal-v2-inner">

                <p class="title">Share your love on <br>
                    <svg width="101" height="24" viewBox="0 0 101 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_8189_44978)">
                            <path d="M26.4373 8.57031H36.585V10.4007H32.5949V20.6899H30.4008V10.4007H26.4285V8.57031H26.4373ZM36.1515 11.9145H38.027V13.608H38.0624C38.1244 13.3686 38.2394 13.1376 38.4075 12.9152C38.5756 12.6929 38.7791 12.479 39.0179 12.2994C39.2568 12.1113 39.5222 11.9659 39.8142 11.8461C40.1061 11.7349 40.4069 11.6751 40.7077 11.6751C40.9377 11.6751 41.1058 11.6836 41.1943 11.6922C41.2828 11.7007 41.3713 11.7178 41.4686 11.7264V13.5909C41.327 13.5653 41.1855 13.5482 41.0351 13.5311C40.8847 13.514 40.7431 13.5054 40.6016 13.5054C40.2654 13.5054 39.9469 13.5738 39.6461 13.7021C39.3453 13.8304 39.0887 14.0271 38.8675 14.2752C38.6463 14.5318 38.4694 14.8397 38.3367 15.216C38.204 15.5923 38.1421 16.02 38.1421 16.5075V20.6814H36.1426V11.9145L36.1515 11.9145ZM50.6607 20.6899H48.6967V19.4669H48.6613C48.4136 19.9116 48.0508 20.2623 47.5642 20.5274C47.0777 20.7926 46.5822 20.9294 46.0779 20.9294C44.8836 20.9294 44.0165 20.6472 43.4857 20.0741C42.9549 19.5011 42.6895 18.6372 42.6895 17.4826V11.9145H44.6889V17.2944C44.6889 18.0642 44.8393 18.6116 45.149 18.928C45.4498 19.2445 45.8833 19.407 46.4318 19.407C46.8565 19.407 47.2015 19.3471 47.4846 19.2188C47.7677 19.0905 47.9978 18.928 48.1658 18.7142C48.3428 18.5089 48.4667 18.2523 48.5463 17.9615C48.6259 17.6707 48.6613 17.3543 48.6613 17.0121V11.9231H50.6607V20.6899ZM54.0669 17.876C54.1288 18.4405 54.35 18.8339 54.7304 19.0649C55.1197 19.2872 55.5797 19.407 56.1194 19.407C56.3052 19.407 56.5175 19.3899 56.7564 19.3642C56.9953 19.3386 57.2253 19.2787 57.4288 19.2017C57.6411 19.1247 57.8092 19.005 57.9508 18.851C58.0835 18.6971 58.1454 18.5004 58.1366 18.2523C58.1277 18.0043 58.0304 17.799 57.8534 17.6451C57.6765 17.4826 57.4553 17.3628 57.1811 17.2602C56.9068 17.1661 56.5972 17.0806 56.2433 17.0121C55.8894 16.9437 55.5355 16.8667 55.1728 16.7898C54.8012 16.7128 54.4385 16.6101 54.0934 16.499C53.7484 16.3878 53.4387 16.2338 53.1645 16.0371C52.8902 15.8489 52.669 15.6009 52.5098 15.3015C52.3417 15.0022 52.2621 14.6344 52.2621 14.1896C52.2621 13.7107 52.3859 13.3172 52.6248 12.9922C52.8637 12.6672 53.1733 12.4106 53.5361 12.2139C53.9076 12.0172 54.3146 11.8803 54.7658 11.7948C55.217 11.7178 55.6505 11.6751 56.0575 11.6751C56.5264 11.6751 56.9776 11.7264 57.4022 11.8205C57.8269 11.9145 58.2162 12.0685 58.5612 12.2909C58.9062 12.5047 59.1894 12.7869 59.4194 13.1291C59.6494 13.4712 59.791 13.8903 59.8529 14.3778H57.765C57.6677 13.9159 57.4553 13.5995 57.1103 13.4455C56.7653 13.283 56.3671 13.206 55.9248 13.206C55.7832 13.206 55.6151 13.2146 55.4205 13.2403C55.2258 13.2659 55.0489 13.3087 54.872 13.3686C54.7039 13.4284 54.5623 13.5225 54.4385 13.6423C54.3234 13.762 54.2615 13.9159 54.2615 14.1127C54.2615 14.3522 54.35 14.5403 54.5181 14.6857C54.6862 14.8311 54.9074 14.9509 55.1816 15.0535C55.4559 15.1476 55.7655 15.2331 56.1194 15.3015C56.4733 15.37 56.836 15.4469 57.2076 15.5239C57.5703 15.6009 57.9242 15.7035 58.2781 15.8147C58.632 15.9259 58.9416 16.0799 59.2159 16.2766C59.4902 16.4733 59.7113 16.7128 59.8794 17.0036C60.0475 17.2944 60.136 17.6622 60.136 18.0898C60.136 18.6116 60.0121 19.0478 59.7644 19.4155C59.5167 19.7748 59.1982 20.0741 58.8089 20.2965C58.4197 20.5189 57.9773 20.6899 57.4996 20.7926C57.0218 20.8952 56.5441 20.9465 56.0752 20.9465C55.5001 20.9465 54.9693 20.8867 54.4827 20.7584C53.9961 20.6301 53.5714 20.4419 53.2176 20.1939C52.8637 19.9373 52.5806 19.6208 52.3771 19.2445C52.1736 18.8681 52.0674 18.4148 52.0497 17.8931H54.0669V17.876ZM60.6668 11.9145H62.1797V9.28021H64.1791V11.9145H65.984V13.36H64.1791V18.0471C64.1791 18.2523 64.188 18.4234 64.2057 18.5773C64.2234 18.7227 64.2676 18.851 64.3295 18.9537C64.3915 19.0563 64.4888 19.1333 64.6215 19.1846C64.7542 19.2359 64.9223 19.2616 65.1523 19.2616C65.2939 19.2616 65.4354 19.2616 65.577 19.253C65.7185 19.2445 65.8601 19.2274 66.0016 19.1932V20.6899C65.7805 20.7156 65.5593 20.7327 65.3558 20.7584C65.1435 20.784 64.9311 20.7926 64.71 20.7926C64.1791 20.7926 63.7545 20.7413 63.436 20.6472C63.1175 20.5531 62.8609 20.4077 62.684 20.2195C62.4982 20.0314 62.3832 19.8004 62.3124 19.5182C62.2505 19.2359 62.2062 18.9109 62.1974 18.5517V13.3771H60.6845V11.9145H60.6668ZM67.3995 11.9145H69.2928V13.1034H69.3282C69.6113 12.5902 70.0005 12.231 70.5048 12.0086C71.0091 11.7862 71.5488 11.6751 72.1415 11.6751C72.8582 11.6751 73.4775 11.7948 74.0083 12.0428C74.5391 12.2823 74.9815 12.6159 75.3354 13.0435C75.6892 13.4712 75.9458 13.9673 76.1228 14.5318C76.2997 15.0963 76.3882 15.7035 76.3882 16.345C76.3882 16.9352 76.3085 17.5082 76.1493 18.0556C75.99 18.6116 75.7512 19.0991 75.4327 19.5267C75.1142 19.9544 74.7072 20.2879 74.2118 20.5445C73.7163 20.8011 73.1413 20.9294 72.4689 20.9294C72.1769 20.9294 71.885 20.9038 71.593 20.8524C71.3011 20.8011 71.018 20.7156 70.7525 20.6044C70.4871 20.4932 70.2306 20.3478 70.0094 20.1682C69.7794 19.9886 69.5936 19.7833 69.4343 19.5524H69.3989V23.9315H67.3995V11.9145ZM74.3887 16.3108C74.3887 15.9174 74.3356 15.5325 74.2295 15.1561C74.1233 14.7798 73.9641 14.4548 73.7517 14.164C73.5394 13.8732 73.274 13.6423 72.9643 13.4712C72.6458 13.3001 72.2831 13.206 71.8761 13.206C71.0357 13.206 70.3987 13.4883 69.974 14.0528C69.5493 14.6173 69.337 15.37 69.337 16.3108C69.337 16.7555 69.3901 17.1661 69.5051 17.5424C69.6201 17.9188 69.7794 18.2438 70.0094 18.5175C70.2306 18.7912 70.496 19.005 70.8056 19.1589C71.1153 19.3215 71.478 19.3984 71.885 19.3984C72.345 19.3984 72.7255 19.3043 73.044 19.1247C73.3625 18.9451 73.619 18.7056 73.8225 18.4234C74.026 18.1326 74.1764 17.8076 74.2649 17.4398C74.3445 17.072 74.3887 16.6957 74.3887 16.3108ZM77.9187 8.57031H79.9182V10.4007H77.9187V8.57031ZM77.9187 11.9145H79.9182V20.6899H77.9187V11.9145ZM81.7053 8.57031H83.7047V20.6899H81.7053V8.57031ZM89.8358 20.9294C89.1103 20.9294 88.4645 20.8097 87.8983 20.5787C87.3321 20.3478 86.8543 20.0228 86.4562 19.6208C86.0669 19.2103 85.7661 18.7227 85.5626 18.1582C85.3591 17.5937 85.253 16.9694 85.253 16.2937C85.253 15.6266 85.3591 15.0107 85.5626 14.4462C85.7661 13.8817 86.0669 13.3942 86.4562 12.9837C86.8455 12.5731 87.3321 12.2567 87.8983 12.0257C88.4645 11.7948 89.1103 11.6751 89.8358 11.6751C90.5613 11.6751 91.2071 11.7948 91.7733 12.0257C92.3395 12.2567 92.8173 12.5817 93.2154 12.9837C93.6047 13.3942 93.9055 13.8817 94.109 14.4462C94.3124 15.0107 94.4186 15.6266 94.4186 16.2937C94.4186 16.9694 94.3124 17.5937 94.109 18.1582C93.9055 18.7227 93.6047 19.2103 93.2154 19.6208C92.8261 20.0314 92.3395 20.3478 91.7733 20.5787C91.2071 20.8097 90.5613 20.9294 89.8358 20.9294ZM89.8358 19.3984C90.2781 19.3984 90.6674 19.3043 90.9948 19.1247C91.3221 18.9451 91.5875 18.7056 91.7999 18.4148C92.0122 18.124 92.1626 17.7905 92.2688 17.4227C92.3661 17.0549 92.4192 16.6786 92.4192 16.2937C92.4192 15.9174 92.3661 15.5496 92.2688 15.1732C92.1714 14.7969 92.0122 14.4719 91.7999 14.1811C91.5875 13.8903 91.3221 13.6594 90.9948 13.4797C90.6674 13.3001 90.2781 13.206 89.8358 13.206C89.3934 13.206 89.0042 13.3001 88.6768 13.4797C88.3495 13.6594 88.0841 13.8988 87.8717 14.1811C87.6594 14.4719 87.509 14.7969 87.4028 15.1732C87.3055 15.5496 87.2524 15.9174 87.2524 16.2937C87.2524 16.6786 87.3055 17.0549 87.4028 17.4227C87.5001 17.7905 87.6594 18.124 87.8717 18.4148C88.0841 18.7056 88.3495 18.9451 88.6768 19.1247C89.0042 19.3129 89.3934 19.3984 89.8358 19.3984ZM95.0025 11.9145H96.5154V9.28021H98.5148V11.9145H100.32V13.36H98.5148V18.0471C98.5148 18.2523 98.5237 18.4234 98.5414 18.5773C98.5591 18.7227 98.6033 18.851 98.6652 18.9537C98.7272 19.0563 98.8245 19.1333 98.9572 19.1846C99.0899 19.2359 99.258 19.2616 99.488 19.2616C99.6296 19.2616 99.7711 19.2616 99.9127 19.253C100.054 19.2445 100.196 19.2274 100.337 19.1932V20.6899C100.116 20.7156 99.895 20.7327 99.6915 20.7584C99.4792 20.784 99.2668 20.7926 99.0456 20.7926C98.5148 20.7926 98.0902 20.7413 97.7717 20.6472C97.4532 20.5531 97.1966 20.4077 97.0197 20.2195C96.8339 20.0314 96.7189 19.8004 96.6481 19.5182C96.5861 19.2359 96.5419 18.9109 96.5331 18.5517V13.3771H95.0202V11.9145L95.0025 11.9145Z"
                                  fill="black"/>
                            <path d="M24.1022 8.56999H14.9366L12.1055 0.136719L9.26559 8.56999L0.0999756 8.56144L7.52271 13.7788L4.68279 22.2035L12.1055 16.9947L19.5194 22.2035L16.6883 13.7788L24.1022 8.56999Z"
                                  fill="#00B67A"/>
                            <path d="M17.3256 15.6866L16.6886 13.7793L12.1058 16.9952L17.3256 15.6866Z" fill="#005128"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_8189_44978">
                                <rect width="100.8" height="24" fill="white" transform="translate(0.0999756)"/>
                            </clipPath>
                        </defs>
                    </svg>
                </p>
                <p class="text">
                    We’re so glad you’re enjoying our site! Could you take a moment to leave us a quick review on TrustPilot? Your feedback helps others discover us too!
                </p>

                <a class="trustpilot-widget"
                   href="https://www.trustpilot.com/evaluate/honeytoon.com"
                   target="_blank"
                   rel="noopener"
                   data-c-event="trustpilot_click"
                   onclick="window.openModal('trustpilot-thanks-modal')"
                >
                 <span>
                     Review us on
                 </span>
                    <svg width="101" height="24" viewBox="0 0 101 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_8189_44978)">
                            <path d="M26.4373 8.57031H36.585V10.4007H32.5949V20.6899H30.4008V10.4007H26.4285V8.57031H26.4373ZM36.1515 11.9145H38.027V13.608H38.0624C38.1244 13.3686 38.2394 13.1376 38.4075 12.9152C38.5756 12.6929 38.7791 12.479 39.0179 12.2994C39.2568 12.1113 39.5222 11.9659 39.8142 11.8461C40.1061 11.7349 40.4069 11.6751 40.7077 11.6751C40.9377 11.6751 41.1058 11.6836 41.1943 11.6922C41.2828 11.7007 41.3713 11.7178 41.4686 11.7264V13.5909C41.327 13.5653 41.1855 13.5482 41.0351 13.5311C40.8847 13.514 40.7431 13.5054 40.6016 13.5054C40.2654 13.5054 39.9469 13.5738 39.6461 13.7021C39.3453 13.8304 39.0887 14.0271 38.8675 14.2752C38.6463 14.5318 38.4694 14.8397 38.3367 15.216C38.204 15.5923 38.1421 16.02 38.1421 16.5075V20.6814H36.1426V11.9145L36.1515 11.9145ZM50.6607 20.6899H48.6967V19.4669H48.6613C48.4136 19.9116 48.0508 20.2623 47.5642 20.5274C47.0777 20.7926 46.5822 20.9294 46.0779 20.9294C44.8836 20.9294 44.0165 20.6472 43.4857 20.0741C42.9549 19.5011 42.6895 18.6372 42.6895 17.4826V11.9145H44.6889V17.2944C44.6889 18.0642 44.8393 18.6116 45.149 18.928C45.4498 19.2445 45.8833 19.407 46.4318 19.407C46.8565 19.407 47.2015 19.3471 47.4846 19.2188C47.7677 19.0905 47.9978 18.928 48.1658 18.7142C48.3428 18.5089 48.4667 18.2523 48.5463 17.9615C48.6259 17.6707 48.6613 17.3543 48.6613 17.0121V11.9231H50.6607V20.6899ZM54.0669 17.876C54.1288 18.4405 54.35 18.8339 54.7304 19.0649C55.1197 19.2872 55.5797 19.407 56.1194 19.407C56.3052 19.407 56.5175 19.3899 56.7564 19.3642C56.9953 19.3386 57.2253 19.2787 57.4288 19.2017C57.6411 19.1247 57.8092 19.005 57.9508 18.851C58.0835 18.6971 58.1454 18.5004 58.1366 18.2523C58.1277 18.0043 58.0304 17.799 57.8534 17.6451C57.6765 17.4826 57.4553 17.3628 57.1811 17.2602C56.9068 17.1661 56.5972 17.0806 56.2433 17.0121C55.8894 16.9437 55.5355 16.8667 55.1728 16.7898C54.8012 16.7128 54.4385 16.6101 54.0934 16.499C53.7484 16.3878 53.4387 16.2338 53.1645 16.0371C52.8902 15.8489 52.669 15.6009 52.5098 15.3015C52.3417 15.0022 52.2621 14.6344 52.2621 14.1896C52.2621 13.7107 52.3859 13.3172 52.6248 12.9922C52.8637 12.6672 53.1733 12.4106 53.5361 12.2139C53.9076 12.0172 54.3146 11.8803 54.7658 11.7948C55.217 11.7178 55.6505 11.6751 56.0575 11.6751C56.5264 11.6751 56.9776 11.7264 57.4022 11.8205C57.8269 11.9145 58.2162 12.0685 58.5612 12.2909C58.9062 12.5047 59.1894 12.7869 59.4194 13.1291C59.6494 13.4712 59.791 13.8903 59.8529 14.3778H57.765C57.6677 13.9159 57.4553 13.5995 57.1103 13.4455C56.7653 13.283 56.3671 13.206 55.9248 13.206C55.7832 13.206 55.6151 13.2146 55.4205 13.2403C55.2258 13.2659 55.0489 13.3087 54.872 13.3686C54.7039 13.4284 54.5623 13.5225 54.4385 13.6423C54.3234 13.762 54.2615 13.9159 54.2615 14.1127C54.2615 14.3522 54.35 14.5403 54.5181 14.6857C54.6862 14.8311 54.9074 14.9509 55.1816 15.0535C55.4559 15.1476 55.7655 15.2331 56.1194 15.3015C56.4733 15.37 56.836 15.4469 57.2076 15.5239C57.5703 15.6009 57.9242 15.7035 58.2781 15.8147C58.632 15.9259 58.9416 16.0799 59.2159 16.2766C59.4902 16.4733 59.7113 16.7128 59.8794 17.0036C60.0475 17.2944 60.136 17.6622 60.136 18.0898C60.136 18.6116 60.0121 19.0478 59.7644 19.4155C59.5167 19.7748 59.1982 20.0741 58.8089 20.2965C58.4197 20.5189 57.9773 20.6899 57.4996 20.7926C57.0218 20.8952 56.5441 20.9465 56.0752 20.9465C55.5001 20.9465 54.9693 20.8867 54.4827 20.7584C53.9961 20.6301 53.5714 20.4419 53.2176 20.1939C52.8637 19.9373 52.5806 19.6208 52.3771 19.2445C52.1736 18.8681 52.0674 18.4148 52.0497 17.8931H54.0669V17.876ZM60.6668 11.9145H62.1797V9.28021H64.1791V11.9145H65.984V13.36H64.1791V18.0471C64.1791 18.2523 64.188 18.4234 64.2057 18.5773C64.2234 18.7227 64.2676 18.851 64.3295 18.9537C64.3915 19.0563 64.4888 19.1333 64.6215 19.1846C64.7542 19.2359 64.9223 19.2616 65.1523 19.2616C65.2939 19.2616 65.4354 19.2616 65.577 19.253C65.7185 19.2445 65.8601 19.2274 66.0016 19.1932V20.6899C65.7805 20.7156 65.5593 20.7327 65.3558 20.7584C65.1435 20.784 64.9311 20.7926 64.71 20.7926C64.1791 20.7926 63.7545 20.7413 63.436 20.6472C63.1175 20.5531 62.8609 20.4077 62.684 20.2195C62.4982 20.0314 62.3832 19.8004 62.3124 19.5182C62.2505 19.2359 62.2062 18.9109 62.1974 18.5517V13.3771H60.6845V11.9145H60.6668ZM67.3995 11.9145H69.2928V13.1034H69.3282C69.6113 12.5902 70.0005 12.231 70.5048 12.0086C71.0091 11.7862 71.5488 11.6751 72.1415 11.6751C72.8582 11.6751 73.4775 11.7948 74.0083 12.0428C74.5391 12.2823 74.9815 12.6159 75.3354 13.0435C75.6892 13.4712 75.9458 13.9673 76.1228 14.5318C76.2997 15.0963 76.3882 15.7035 76.3882 16.345C76.3882 16.9352 76.3085 17.5082 76.1493 18.0556C75.99 18.6116 75.7512 19.0991 75.4327 19.5267C75.1142 19.9544 74.7072 20.2879 74.2118 20.5445C73.7163 20.8011 73.1413 20.9294 72.4689 20.9294C72.1769 20.9294 71.885 20.9038 71.593 20.8524C71.3011 20.8011 71.018 20.7156 70.7525 20.6044C70.4871 20.4932 70.2306 20.3478 70.0094 20.1682C69.7794 19.9886 69.5936 19.7833 69.4343 19.5524H69.3989V23.9315H67.3995V11.9145ZM74.3887 16.3108C74.3887 15.9174 74.3356 15.5325 74.2295 15.1561C74.1233 14.7798 73.9641 14.4548 73.7517 14.164C73.5394 13.8732 73.274 13.6423 72.9643 13.4712C72.6458 13.3001 72.2831 13.206 71.8761 13.206C71.0357 13.206 70.3987 13.4883 69.974 14.0528C69.5493 14.6173 69.337 15.37 69.337 16.3108C69.337 16.7555 69.3901 17.1661 69.5051 17.5424C69.6201 17.9188 69.7794 18.2438 70.0094 18.5175C70.2306 18.7912 70.496 19.005 70.8056 19.1589C71.1153 19.3215 71.478 19.3984 71.885 19.3984C72.345 19.3984 72.7255 19.3043 73.044 19.1247C73.3625 18.9451 73.619 18.7056 73.8225 18.4234C74.026 18.1326 74.1764 17.8076 74.2649 17.4398C74.3445 17.072 74.3887 16.6957 74.3887 16.3108ZM77.9187 8.57031H79.9182V10.4007H77.9187V8.57031ZM77.9187 11.9145H79.9182V20.6899H77.9187V11.9145ZM81.7053 8.57031H83.7047V20.6899H81.7053V8.57031ZM89.8358 20.9294C89.1103 20.9294 88.4645 20.8097 87.8983 20.5787C87.3321 20.3478 86.8543 20.0228 86.4562 19.6208C86.0669 19.2103 85.7661 18.7227 85.5626 18.1582C85.3591 17.5937 85.253 16.9694 85.253 16.2937C85.253 15.6266 85.3591 15.0107 85.5626 14.4462C85.7661 13.8817 86.0669 13.3942 86.4562 12.9837C86.8455 12.5731 87.3321 12.2567 87.8983 12.0257C88.4645 11.7948 89.1103 11.6751 89.8358 11.6751C90.5613 11.6751 91.2071 11.7948 91.7733 12.0257C92.3395 12.2567 92.8173 12.5817 93.2154 12.9837C93.6047 13.3942 93.9055 13.8817 94.109 14.4462C94.3124 15.0107 94.4186 15.6266 94.4186 16.2937C94.4186 16.9694 94.3124 17.5937 94.109 18.1582C93.9055 18.7227 93.6047 19.2103 93.2154 19.6208C92.8261 20.0314 92.3395 20.3478 91.7733 20.5787C91.2071 20.8097 90.5613 20.9294 89.8358 20.9294ZM89.8358 19.3984C90.2781 19.3984 90.6674 19.3043 90.9948 19.1247C91.3221 18.9451 91.5875 18.7056 91.7999 18.4148C92.0122 18.124 92.1626 17.7905 92.2688 17.4227C92.3661 17.0549 92.4192 16.6786 92.4192 16.2937C92.4192 15.9174 92.3661 15.5496 92.2688 15.1732C92.1714 14.7969 92.0122 14.4719 91.7999 14.1811C91.5875 13.8903 91.3221 13.6594 90.9948 13.4797C90.6674 13.3001 90.2781 13.206 89.8358 13.206C89.3934 13.206 89.0042 13.3001 88.6768 13.4797C88.3495 13.6594 88.0841 13.8988 87.8717 14.1811C87.6594 14.4719 87.509 14.7969 87.4028 15.1732C87.3055 15.5496 87.2524 15.9174 87.2524 16.2937C87.2524 16.6786 87.3055 17.0549 87.4028 17.4227C87.5001 17.7905 87.6594 18.124 87.8717 18.4148C88.0841 18.7056 88.3495 18.9451 88.6768 19.1247C89.0042 19.3129 89.3934 19.3984 89.8358 19.3984ZM95.0025 11.9145H96.5154V9.28021H98.5148V11.9145H100.32V13.36H98.5148V18.0471C98.5148 18.2523 98.5237 18.4234 98.5414 18.5773C98.5591 18.7227 98.6033 18.851 98.6652 18.9537C98.7272 19.0563 98.8245 19.1333 98.9572 19.1846C99.0899 19.2359 99.258 19.2616 99.488 19.2616C99.6296 19.2616 99.7711 19.2616 99.9127 19.253C100.054 19.2445 100.196 19.2274 100.337 19.1932V20.6899C100.116 20.7156 99.895 20.7327 99.6915 20.7584C99.4792 20.784 99.2668 20.7926 99.0456 20.7926C98.5148 20.7926 98.0902 20.7413 97.7717 20.6472C97.4532 20.5531 97.1966 20.4077 97.0197 20.2195C96.8339 20.0314 96.7189 19.8004 96.6481 19.5182C96.5861 19.2359 96.5419 18.9109 96.5331 18.5517V13.3771H95.0202V11.9145L95.0025 11.9145Z"
                                  fill="black"/>
                            <path d="M24.1022 8.56999H14.9366L12.1055 0.136719L9.26559 8.56999L0.0999756 8.56144L7.52271 13.7788L4.68279 22.2035L12.1055 16.9947L19.5194 22.2035L16.6883 13.7788L24.1022 8.56999Z"
                                  fill="#00B67A"/>
                            <path d="M17.3256 15.6866L16.6886 13.7793L12.1058 16.9952L17.3256 15.6866Z" fill="#005128"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_8189_44978">
                                <rect width="100.8" height="24" fill="white" transform="translate(0.0999756)"/>
                            </clipPath>
                        </defs>
                    </svg>
                </a>

            </div>

        </div>
    </div>
</div>    
    <div class="modal modal-last-minute-deal"
     data-at-appear-c-event='view_bounce_modal|{"modal": "other"}'
     id="last-minute-deal-modal">
    <div class="modal-bg"></div>
    <div class="modal-content">
        <span class="close close-modal modal-exit"
              data-c-event='bm_close_click|{"modal": "other"}'>
                  <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                          fill="black"/>
                </svg>
            </span>
        <div class="modal-body">
                            <p class="modal__title">last-minute deal!</p>
                <p class="modal__desc">
                    Unlock all our content<br/>
                    <span>only 7.99 per week!*</span>
                </p>
                <a href="https://honeytoon.com/account/levels?type=special"
                   data-c-event='bm_claim_offer_click|{"modal": "other"}'
                    class="btn btn-yellow btn-yellow--big">Claim Offer</a>
                <p class="modal__desc1">*regular price 13.49 per month</p>
                    </div>

    </div>
</div>
            <footer class="footer">
    <div class="container">
        <div class="footer-top">

            <img class="footer__logo" src="build/images/logo/logo.svg@t=9723654" alt="logo">
            <div class="footer__language-switcher" onclick="this.classList.toggle('active')">

                                                                                        <span>English</span>
                                                                                                                                                                                                                                                                        
                    <div class="footer__language-switcher--select">
                                                    <a href="javascript:void(0)" data-locale="en" class="language-switcher-btn active">English</a>
                                                    <a href="fr.html" data-locale="fr" class="language-switcher-btn ">Français</a>
                                                    <a href="de.html" data-locale="de" class="language-switcher-btn ">Deutsch</a>
                                                    <a href="es.html" data-locale="es" class="language-switcher-btn ">Español</a>
                                                    <a href="pt.html" data-locale="pt" class="language-switcher-btn ">Português</a>
                                                    <a href="it.html" data-locale="it" class="language-switcher-btn ">Italiano</a>
                                            </div>

                    <span class="footer__language-switcher-arrow">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M8.00048 8.78145L11.3005 5.48145L12.2431 6.42411L8.00048 10.6668L3.75781 6.42411L4.70048 5.48145L8.00048 8.78145Z" fill="black"/>
                        </svg>
                    </span>
                
            </div>
        </div>

        <nav class="footer-nav" aria-label="Main">
            <ul class="footer-nav__list">
                <li class="footer-nav__item">
                    <a href="contact-us.html" class="footer-nav__link">Contact us</a>
                </li>
                <li class="footer-nav__item">
                    <a href="payment-refund-policy.html" class="footer-nav__link">Payment &amp; Refund Policy</a>
                </li>
                <li class="footer-nav__item">
                    <a href="terms-and-conditions.html" class="footer-nav__link">Terms and conditions</a>
                </li>
                <li class="footer-nav__item">
                    <a href="privacy-policy.html" class="footer-nav__link">Privacy policy</a>
                </li>
                <li class="footer-nav__item">
                    <a href="faq.html" class="footer-nav__link">FAQ</a>
                </li>
            </ul>
        </nav>

        <div class="footer-bottom">
            <div class="footer-social social">
                    <a href="https://www.facebook.com/honeytoon.en" target="_blank" rel="nofollow" class="social__link">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M12 2C6.477 2 2 6.477 2 12C2 16.991 5.657 21.128 10.438 21.879V14.89H7.898V12H10.438V9.797C10.438 7.291 11.93 5.907 14.215 5.907C15.309 5.907 16.453 6.102 16.453 6.102V8.562H15.193C13.95 8.562 13.563 9.333 13.563 10.124V12H16.336L15.893 14.89H13.563V21.879C18.343 21.129 22 16.99 22 12C22 6.477 17.523 2 12 2Z" fill="white"/>
        </svg>
    </a>
    <a href="https://www.instagram.com/honeytoon_comics?igsh=anpidXhscnowdDIx" target="_blank" rel="nofollow" class="social__link">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_380_24553)">
                <path d="M12 9C11.2044 9 10.4413 9.31607 9.87868 9.87868C9.31607 10.4413 9 11.2044 9 12C9 12.7956 9.31607 13.5587 9.87868 14.1213C10.4413 14.6839 11.2044 15 12 15C12.7956 15 13.5587 14.6839 14.1213 14.1213C14.6839 13.5587 15 12.7956 15 12C15 11.2044 14.6839 10.4413 14.1213 9.87868C13.5587 9.31607 12.7956 9 12 9ZM12 7C13.3261 7 14.5979 7.52678 15.5355 8.46447C16.4732 9.40215 17 10.6739 17 12C17 13.3261 16.4732 14.5979 15.5355 15.5355C14.5979 16.4732 13.3261 17 12 17C10.6739 17 9.40215 16.4732 8.46447 15.5355C7.52678 14.5979 7 13.3261 7 12C7 10.6739 7.52678 9.40215 8.46447 8.46447C9.40215 7.52678 10.6739 7 12 7ZM18.5 6.75C18.5 7.08152 18.3683 7.39946 18.1339 7.63388C17.8995 7.8683 17.5815 8 17.25 8C16.9185 8 16.6005 7.8683 16.3661 7.63388C16.1317 7.39946 16 7.08152 16 6.75C16 6.41848 16.1317 6.10054 16.3661 5.86612C16.6005 5.6317 16.9185 5.5 17.25 5.5C17.5815 5.5 17.8995 5.6317 18.1339 5.86612C18.3683 6.10054 18.5 6.41848 18.5 6.75ZM12 4C9.526 4 9.122 4.007 7.971 4.058C7.187 4.095 6.661 4.2 6.173 4.39C5.739 4.558 5.426 4.759 5.093 5.093C4.78001 5.3954 4.53935 5.76458 4.389 6.173C4.199 6.663 4.094 7.188 4.058 7.971C4.006 9.075 4 9.461 4 12C4 14.474 4.007 14.878 4.058 16.029C4.095 16.812 4.2 17.339 4.389 17.826C4.559 18.261 4.759 18.574 5.091 18.906C5.428 19.242 5.741 19.443 6.171 19.609C6.665 19.8 7.191 19.906 7.971 19.942C9.075 19.994 9.461 20 12 20C14.474 20 14.878 19.993 16.029 19.942C16.811 19.905 17.338 19.8 17.826 19.611C18.259 19.442 18.574 19.241 18.906 18.909C19.243 18.572 19.444 18.259 19.61 17.829C19.8 17.336 19.906 16.809 19.942 16.029C19.994 14.925 20 14.539 20 12C20 9.526 19.993 9.122 19.942 7.971C19.905 7.189 19.8 6.661 19.61 6.173C19.4593 5.765 19.2191 5.39596 18.907 5.093C18.6047 4.77985 18.2355 4.53917 17.827 4.389C17.337 4.199 16.811 4.094 16.029 4.058C14.925 4.006 14.539 4 12 4ZM12 2C14.717 2 15.056 2.01 16.122 2.06C17.187 2.11 17.912 2.277 18.55 2.525C19.21 2.779 19.766 3.123 20.322 3.678C20.8305 4.1779 21.224 4.78259 21.475 5.45C21.722 6.087 21.89 6.813 21.94 7.878C21.987 8.944 22 9.283 22 12C22 14.717 21.99 15.056 21.94 16.122C21.89 17.187 21.722 17.912 21.475 18.55C21.2247 19.2178 20.8311 19.8226 20.322 20.322C19.822 20.8303 19.2173 21.2238 18.55 21.475C17.913 21.722 17.187 21.89 16.122 21.94C15.056 21.987 14.717 22 12 22C9.283 22 8.944 21.99 7.878 21.94C6.813 21.89 6.088 21.722 5.45 21.475C4.78233 21.2245 4.17753 20.8309 3.678 20.322C3.16941 19.8222 2.77593 19.2175 2.525 18.55C2.277 17.913 2.11 17.187 2.06 16.122C2.013 15.056 2 14.717 2 12C2 9.283 2.01 8.944 2.06 7.878C2.11 6.812 2.277 6.088 2.525 5.45C2.77524 4.78218 3.1688 4.17732 3.678 3.678C4.17767 3.16923 4.78243 2.77573 5.45 2.525C6.088 2.277 6.812 2.11 7.878 2.06C8.944 2.013 9.283 2 12 2Z" fill="white"/>
            </g>
            <defs>
                <clipPath id="clip0_380_24553">
                    <rect width="24" height="24" fill="white"/>
                </clipPath>
            </defs>
        </svg>
    </a>
<a href="https://twitter.com/Honeytoon_en" target="_blank" rel="nofollow" class="social__link">
    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
        <path d="M18.2048 2.25H21.5128L14.2858 10.51L22.7878 21.75H16.1298L10.9158 14.933L4.94984 21.75H1.63984L9.36984 12.915L1.21484 2.25H8.03984L12.7528 8.481L18.2028 2.25H18.2048ZM17.0438 19.77H18.8768L7.04484 4.126H5.07784L17.0438 19.77Z" fill="white"/>
    </svg>
</a>
<a href="https://www.tiktok.com/@honeytoon_co" target="_blank" rel="nofollow" class="social__link">
    <svg fill="#ffffff" width="24" height="24" viewBox="0 0 512 512" id="icons" xmlns="http://www.w3.org/2000/svg"
         stroke="#ffffff">
        <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
        <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
        <g id="SVGRepo_iconCarrier">
            <path d="M412.19,118.66a109.27,109.27,0,0,1-9.45-5.5,132.87,132.87,0,0,1-24.27-20.62c-18.1-20.71-24.86-41.72-27.35-56.43h.1C349.14,23.9,350,16,350.13,16H267.69V334.78c0,4.28,0,8.51-.18,12.69,0,.52-.05,1-.08,1.56,0,.23,0,.47-.05.71,0,.06,0,.12,0,.18a70,70,0,0,1-35.22,55.56,68.8,68.8,0,0,1-34.11,9c-38.41,0-69.54-31.32-69.54-70s31.13-70,69.54-70a68.9,68.9,0,0,1,21.41,3.39l.1-83.94a153.14,153.14,0,0,0-118,34.52,161.79,161.79,0,0,0-35.3,43.53c-3.48,6-16.61,30.11-18.2,69.24-1,22.21,5.67,45.22,8.85,54.73v.2c2,5.6,9.75,24.71,22.38,40.82A167.53,167.53,0,0,0,115,470.66v-.2l.2.2C155.11,497.78,199.36,496,199.36,496c7.66-.31,33.32,0,62.46-13.81,32.32-15.31,50.72-38.12,50.72-38.12a158.46,158.46,0,0,0,27.64-45.93c7.46-19.61,9.95-43.13,9.95-52.53V176.49c1,.6,14.32,9.41,14.32,9.41s19.19,12.3,49.13,20.31c21.48,5.7,50.42,6.9,50.42,6.9V131.27C453.86,132.37,433.27,129.17,412.19,118.66Z"></path>
        </g>
    </svg>
</a>
            </div>
            <p class="footer-copyright">
                
                                    <span class="footer-copyright-cols">
                        <span class="">
                            2025 HoneyToon. All rights reserved<br/>
                            Our EU Company:<br/>HONEYTECH LTD<br/>Registration number: НЕ 443020<br/>Legal address:<br/> A.G. Leventi, 5 THE LEVENTIS GALLERY TOWER,<br/> 13th floor, Flat/Office 1301, 1097, <br/>Nicosia, Cyprus
                        </span>
                        <span>
                            <i style="visibility: hidden">2025 HoneyToon. All rights reserved</i><br/>
                            Our HK Company:<br/>HONEYTECH HK LIMITED<br/>Registration number: 77075208<br/>Legal address:<br/> Unit 915, 9/F., CONCORDIA PLAZA,<br/> 1 Science Museum Road, <br/>Tsim Sha Tsui, Hong Kong
                        </span>
                    </span>
                
                            </p>
        </div>
    </div>
</footer>

        <div class="modal ask-modal " id="ask-modal">
    <div class="modal-bg"></div>
    <div class="modal-content" data-at-appear-ga-event='{"event":"view","element":"age_verification","element_location":"age_verification_modal"}'>
        <div class="modal-body">
            <span class="modal__title">Age verification</span>
            <div class="modal__title-main">Are you over the age of 18?</div>
            <p class="modal__desc">You need to confirm that you are over the age of 18 to read adult content.</p>
            <div class="modal-btn-wrap">
                <a class="btn btn-black"
                   id="modalBtnNo"
                   data-ga-event='{"event":"click","element":"age_verification_confirmation","action":"18_plus","element_location":"age_verification_modal"}'
                   href="comic/the-head-of-a-womens-association.html">No</a>
                <a class="btn btn-yellow btn-yellow--big" data-disable_reload="0"
                   id="modalBtnYes"
                   data-ga-event='{"event":"click","element":"age_verification_confirmation","action":"18_minus","element_location":"age_verification_modal"}'
                   href="javascript:void(0)">Yes</a>
            </div>
        </div>
    </div>
</div>
        <div class="modal rebill-error-modal" id="rebill-error-modal">
    <div class="modal-bg"></div>
    <div class="modal-content">
        <div class="modal-body">
            <div class="modal-body-right">
                <span class="close close-modal modal-exit">
                      <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z" fill="black"/>
                    </svg>
                </span>
                <span class="modal__title modal__title--left">Oh No!</span>
                <div class="modal__title-main">We have a problem with your payment for the Membership.</div>
                <div class="alert alert-danger" role="alert">
                    <svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9.72183 0.500126L17.6602 14.2501C17.7333 14.3768 17.7718 14.5205 17.7718 14.6668C17.7718 14.8131 17.7333 14.9568 17.6602 15.0834C17.587 15.2101 17.4818 15.3153 17.3552 15.3885C17.2285 15.4616 17.0848 15.5001 16.9385 15.5001H1.06183C0.915549 15.5001 0.771848 15.4616 0.645169 15.3885C0.518489 15.3153 0.413294 15.2101 0.340156 15.0834C0.267018 14.9568 0.228515 14.8131 0.228516 14.6668C0.228517 14.5205 0.267022 14.3768 0.340161 14.2501L8.27849 0.500126C8.35164 0.373453 8.45683 0.268264 8.58351 0.195131C8.71019 0.121997 8.85389 0.0834961 9.00016 0.0834961C9.14643 0.0834961 9.29013 0.121997 9.41681 0.195131C9.54349 0.268264 9.64868 0.373453 9.72183 0.500126ZM2.50516 13.8335H15.4952L9.00016 2.58346L2.50516 13.8335ZM8.16683 11.3335H9.83349V13.0001H8.16683V11.3335ZM8.16683 5.50013H9.83349V9.66679H8.16683V5.50013Z" fill="#FF514D"/>
                    </svg>
                    Unlimited Access is suspended until the next successful billing.
                </div>
                <p class="modal__desc">Please make sure you have enough funds on your card and update the billing information.</p>
                <a href="comic/my-stepmom/40.html"
                   rel="nofollow"
                   data-token="29.Ie5d2kaBIBzSVouRs5ZExMsKUicaU4tz_O4MxLn_9DU.Vqclr3febUmhPMbL_MIl9YI6Am5_Ju4btaBYsPfLjE1Yr2jta_hraZURzg"
                   class="btn btn-yellow btn-yellow--big w-100 update_billing_click">Update Billing</a>
            </div>
        </div>
    </div>
</div>        

<div class="modal modal-thanks " id="thanks-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-content">
        <div class="modal-body">
            <a class="close close-modal" href="comic/the-head-of-a-womens-association.html">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                          fill="black"/>
                </svg>
            </a>
                            <span class="modal__title modal__title--left">Congratulations!</span>
                                    <p class="modal__desc">Your HoneyToon account was successfully created!</p>
                                        <a href="comic/the-head-of-a-womens-association.html"
               class="btn btn-yellow btn-yellow--big w-100">Ok, thanks</a>
        </div>
    </div>
</div>            <div class="modal modal-survey" id="survey-modal">
        <div class="modal-bg modal-exit"></div>
        <div class="modal-content">
            <div class="modal-body">
                <a class="close close-modal modal-exit" href="javascript:void(0)">
                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                              fill="black"/>
                    </svg>
                </a>
                <span class="modal__title modal__title--left">Bzzz... Survey time!</span>
                <p class="modal__desc">We need your feedback to become better and give you the sweetest experience ever!</p>
                <a href="https://forms.gle/DqJFCi48d2vnmNQ29" target="_blank"
                                          rel="nofollow"
                                      onclick="window.surveyClick()"
                   class="btn btn-yellow btn-yellow--big w-100">Take the Survey!</a>

                                    <img data-loading="lazy" class="mobile" src="https://pic.honeytoon.com/uploads/s31-single/625b5bc8-cc4a-407c-be36-777676390502-1697642972-66.png"
                         srcset="https://pic.honeytoon.com/uploads/s31-single/625b5bc8-cc4a-407c-be36-777676390502-1697642972-66.png"
                         alt="Bzzz... Survey time!"/>
                    <img data-loading="lazy" class="desktop" src="https://pic.honeytoon.com/uploads/s31-single/b31d07f7-ff0e-4f38-9be0-d36a23acfb8a-1691654459-47.png"
                         srcset="https://pic.honeytoon.com/uploads/s31-single/b31d07f7-ff0e-4f38-9be0-d36a23acfb8a-1691654459-47.png"
                         alt="Bzzz... Survey time!"/>
                
            </div>
        </div>
    </div>
            <div class="modal modal-synopsis-collection" id="synopsis-collection-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-content">
        <div class="modal-body">
            <a class="close close-modal modal-exit" href="javascript:void(0)">
                  <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z" fill="black"/>
                </svg>
            </a>
            <div class="modal-body-row modal-body-row--left">
                <p class="modal-body-h1">Got an Amazing Idea for a New Comic?</p>
                <p class="modal-body-h3 bold">Hey there, Comic Enthusiast!</p>
                <p class="modal-body-h3 last">🎉 Submit Your Idea for a Comic Synopsis and You Could Be Featured! 🎉</p>
                <p class="modal-body-h2">Don&#039;t miss this opportunity to let your imagination soar! 👉</p>
            </div>
            <div class="modal-body-row modal-body-row--right">
                <p class="modal-body-h1 modal-body-h1-2">How it Works:</p>
                <ul class="modal-body-list">
                    <li>Write a brief synopsis of a comic you&#039;d love to see come to life.</li>
                    <li>Submit it through the form.</li>
                    <li>If your idea is chosen, you&#039;ll get credit and a special prize!</li>
                </ul>
                <a href="become-author.html" class="btn btn-yellow btn-yellow--big w-100">Let&#039;s start</a>
            </div>
        </div>
    </div>
</div>                    <div class="modal modal-active-cancelled-unlim-success" id="active-cancelled-unlim-success-modal">
        <div class="modal-bg modal-exit"></div>
        <div class="modal-content">
            <div class="modal-body">

            <span class="close close-modal modal-exit">
                  <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z" fill="black"/>
                </svg>
            </span>

                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
    <path d="M20 36.6663C10.795 36.6663 3.33331 29.2047 3.33331 19.9997C3.33331 10.7947 10.795 3.33301 20 3.33301C29.205 3.33301 36.6666 10.7947 36.6666 19.9997C36.6666 29.2047 29.205 36.6663 20 36.6663ZM20 33.333C23.5362 33.333 26.9276 31.9283 29.4281 29.4278C31.9286 26.9273 33.3333 23.5359 33.3333 19.9997C33.3333 16.4635 31.9286 13.0721 29.4281 10.5716C26.9276 8.0711 23.5362 6.66634 20 6.66634C16.4638 6.66634 13.0724 8.0711 10.5719 10.5716C8.0714 13.0721 6.66665 16.4635 6.66665 19.9997C6.66665 23.5359 8.0714 26.9273 10.5719 29.4278C13.0724 31.9283 16.4638 33.333 20 33.333ZM11.6666 21.6663H15C15 22.9924 15.5268 24.2642 16.4644 25.2019C17.4021 26.1396 18.6739 26.6663 20 26.6663C21.3261 26.6663 22.5978 26.1396 23.5355 25.2019C24.4732 24.2642 25 22.9924 25 21.6663H28.3333C28.3333 23.8765 27.4553 25.9961 25.8925 27.5589C24.3297 29.1217 22.2101 29.9997 20 29.9997C17.7898 29.9997 15.6702 29.1217 14.1074 27.5589C12.5446 25.9961 11.6666 23.8765 11.6666 21.6663ZM13.3333 18.333C12.6703 18.333 12.0344 18.0696 11.5655 17.6008C11.0967 17.1319 10.8333 16.496 10.8333 15.833C10.8333 15.17 11.0967 14.5341 11.5655 14.0652C12.0344 13.5964 12.6703 13.333 13.3333 13.333C13.9964 13.333 14.6322 13.5964 15.1011 14.0652C15.5699 14.5341 15.8333 15.17 15.8333 15.833C15.8333 16.496 15.5699 17.1319 15.1011 17.6008C14.6322 18.0696 13.9964 18.333 13.3333 18.333ZM26.6666 18.333C26.0036 18.333 25.3677 18.0696 24.8989 17.6008C24.43 17.1319 24.1666 16.496 24.1666 15.833C24.1666 15.17 24.43 14.5341 24.8989 14.0652C25.3677 13.5964 26.0036 13.333 26.6666 13.333C27.3297 13.333 27.9656 13.5964 28.4344 14.0652C28.9033 14.5341 29.1666 15.17 29.1666 15.833C29.1666 16.496 28.9033 17.1319 28.4344 17.6008C27.9656 18.0696 27.3297 18.333 26.6666 18.333Z" fill="black"/>
</svg>
                <span class="modal__title">Success!</span>
                <span class="modal__sub_title">Premium Membership successfully renewed! Enjoy Unlimited Access to our stories</span>
                <span class="modal__text">The next payment scheduled for May 2, 2025</span>
                <button type="button" class="btn btn-black w-100 close-modal modal-exit" onclick="window.location.reload()">
                    OK
                </button>

            </div>
        </div>
    </div>
        <div class="modal modal-active-cancelled-unlim-error" id="active-cancelled-unlim-error-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-content">
        <div class="modal-body">

            <span class="close close-modal modal-exit">
                  <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z" fill="black"/>
                </svg>
            </span>

            <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
    <path d="M20.5 3.83301C29.705 3.83301 37.1667 11.2947 37.1667 20.4997C37.1667 21.7113 37.0383 22.8913 36.7917 24.0297L33.8217 21.058C33.944 18.1326 33.0999 15.2483 31.4198 12.8503C29.7397 10.4523 27.317 8.67407 24.5256 7.79005C21.7343 6.90602 18.7296 6.96539 15.9754 7.95899C13.2211 8.95259 10.8705 10.8252 9.28646 13.2876C7.70239 15.7501 6.97292 18.6655 7.21067 21.5838C7.44843 24.5021 8.64018 27.261 10.6019 29.4346C12.5637 31.6082 15.1864 33.0756 18.0651 33.6103C20.9439 34.145 23.9186 33.7172 26.53 32.393C27.1661 33.4012 28.0611 34.2203 29.1217 34.7647C26.522 36.3398 23.5396 37.1706 20.5 37.1663C11.295 37.1663 3.83334 29.7047 3.83334 20.4997C3.83334 11.2947 11.295 3.83301 20.5 3.83301ZM32.1667 24.1197L34.5233 26.4763C34.9821 26.9349 35.2971 27.5174 35.4297 28.1524C35.5623 28.7874 35.5067 29.4473 35.2698 30.0511C35.0329 30.655 34.625 31.1766 34.096 31.5521C33.567 31.9275 32.94 32.1404 32.2918 32.1648C31.6436 32.1891 31.0023 32.0238 30.4467 31.6891C29.8911 31.3543 29.4452 30.8648 29.1637 30.2804C28.8822 29.696 28.7773 29.0421 28.8619 28.399C28.9465 27.7558 29.2169 27.1514 29.64 26.6597L29.81 26.4763L32.1667 24.1197ZM20.5 25.4997C22.9433 25.4997 25.1417 26.5513 26.6667 28.228L25.0917 29.6613C23.775 29.1363 22.1967 28.833 20.5 28.833C18.8033 28.833 17.225 29.138 15.9083 29.6597L14.3333 28.2263C15.1137 27.3663 16.0656 26.6793 17.1278 26.2096C18.1899 25.74 19.3387 25.4981 20.5 25.4997ZM14.6667 17.1663C15.3297 17.1663 15.9656 17.4297 16.4344 17.8986C16.9033 18.3674 17.1667 19.0033 17.1667 19.6663C17.1667 20.3294 16.9033 20.9653 16.4344 21.4341C15.9656 21.903 15.3297 22.1663 14.6667 22.1663C14.0036 22.1663 13.3678 21.903 12.8989 21.4341C12.4301 20.9653 12.1667 20.3294 12.1667 19.6663C12.1667 19.0033 12.4301 18.3674 12.8989 17.8986C13.3678 17.4297 14.0036 17.1663 14.6667 17.1663ZM26.3333 17.1663C26.9964 17.1663 27.6323 17.4297 28.1011 17.8986C28.57 18.3674 28.8333 19.0033 28.8333 19.6663C28.8333 20.3294 28.57 20.9653 28.1011 21.4341C27.6323 21.903 26.9964 22.1663 26.3333 22.1663C25.6703 22.1663 25.0344 21.903 24.5656 21.4341C24.0967 20.9653 23.8333 20.3294 23.8333 19.6663C23.8333 19.0033 24.0967 18.3674 24.5656 17.8986C25.0344 17.4297 25.6703 17.1663 26.3333 17.1663Z" fill="black"/>
</svg>
            <span class="modal__title">Something went wrong!</span>
            <span class="modal__sub_title">Your payment did not go through. The card may be blocked or there are no funds on it</span>
            <button type="button" class="btn btn-black w-100 close-modal modal-exit" onclick="Intercom('show');">
                Ask Support
            </button>

        </div>
    </div>
</div>        <div class="modal modal-uncensored-content" id="uncensored-content-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-content">
        <div class="modal-body">

            <span class="close close-modal modal-exit">
                  <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z" fill="black"/>
                </svg>
            </span>

                            <span class="modal__title">Uncensored content is only available with 12 and 24 week premium memberships</span>
            
                                                <a href="https://honeytoon.com/account?modal=change-plan-modal" rel="nofollow" class="btn btn-yellow btn-yellow--big w-100">
                        Upgrade Membership
                    </a>
                            
        </div>
    </div>
</div>        <div class="modal modal-tt-to-external" id="tt-to-external-modal">
    <div class="modal-bg"></div>
    <div class="modal-content">
        <div class="modal-body">


            <p class="modal__title">To continue, please switch to a different browser.</p>

            <p class="modal__desc_step"><i>1</i>Click on the top right corner</p>
            <p class="modal__desc_step"><i>2</i>Choose &quot;Open in browser&quot;</p>
            <p class="modal__desc_step"><i>3</i>Enjoy full version of the comic!</p>

            <img loading="lazy" src="build/images/modal/tt-to-external.webp" alt="To continue, please switch to a different browser." />

        </div>
    </div>
</div>

                <div class="modal modal-uncensored-content-tokens" id="uncensored-content-tokens-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-content">
        <div class="modal-body">
            <span class="close close-modal modal-exit">
                  <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z" fill="black"/>
                </svg>
            </span>

            <p class="modal-title">Uncensored content available only<br/><span>with TOKENS</span></p>

            <a href="comic/the-head-of-a-womens-association.html#" class="btn btn-yellow btn-yellow--big w-100">Get it</a>
        </div>
    </div>
</div>            <div class="modal manga-tokens-pack-modal manga-tokens-pack-modal-first-buy" id="manga-tokens-pack-modal">
        <div class="modal-bg modal-exit"></div>

        <div class="modal-content">
           <span class="close close-modal modal-exit">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                          fill="white"/>
                </svg>
            </span>
            <div class="modal-body">
                <div class="modal-head">
                    <p class="modal-title">Get welcome bonus</p>
                    <p class="modal-description">Choose Tokens Pack&nbsp;<br/>and Unlock MANGA</p>
                </div>

                <div class="modal-content-inner">
                    <p class="manga-tokens-pack-modal__desc">Manga titles are not included in regular comic subscription</p>

                    <div class="manga-tokens-pack" data-set-id="">

                                                                        
                                            </div>

                    <a id="get-manga-tokens"
                       rel="nofollow"
                       class="btn btn-yellow btn-yellow--big w-100"
                       data-c-event='upsell_checkout|{"type":"token"}'
                       data-href="/account/levels?tokens-flow=1&amp;type=manga-tokens-first-buy&amp;lvl=id&amp;loader=1&amp;remove-flow=1"
                       href="https://honeytoon.com/account/levels?tokens-flow=1&amp;type=manga-tokens-first-buy&amp;lvl=0&amp;loader=1&amp;remove-flow=1">
                        Get it
                    </a>

                </div>

            </div>
        </div>
    </div>
        
        
        <div class="modal modal-recovery-password modal-recovery-password-v2  "
     id="recovery-password">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-content">
        <div class="modal-body">
            <span
                                        class="close close-modal modal-exit">
                  <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z"
                          fill="black"/>
                </svg>
            </span>
            <span class="modal__title modal__title--left">Password recovery</span>
            <div class="modal-recovery-form">

                
                    <span class="modal-form__title" style="display: none">We've just sent password recovery instructions to [email].<br><br>Please use them to change your password.</span>
                    <span class="modal-form__title">Maybe you used your social media to Log in.</span>
                    <span class="modal-form__title">Enter Your Email</span>


                    <form action="https://honeytoon.com/reset-password" data-check-action="/check-email-pass-reco" class="modal-form modal-form-recovery">

                        <input type="hidden" name="_csrf_token"
                               value="7eb886717b981e.7XrUlUBRC0nh9y-bjh8hKVuGiJdxVfOEiEHYCuPwTSs.1Cis5QMgQx3YsFzy3EdTTivVxOdcAca23Ta0TaGXOGndNfn2BQQ8DJKvGw">

                        <div class="form-group">
                            <input type="email" name="email" class="form-control w-100"
                                   placeholder="Your Email"
                                   required>
                        </div>

                        <div class="errors" style="display: none"></div>

                        <button type="submit" class="btn btn-yellow btn-yellow--big w-100">Send</button>
                        <button style="display:none;"
                                class="close-modal modal-exit btn btn-black btn-yellow--big w-100">Ok, thanks</button>
                    </form>

                    <p class="modal-form__info" style="display:none;">
                        Remember the password?
                        <button data-modal="sign-in">Log In</button>
                    </p>

                
            </div>

        </div>
    </div>
</div>        <div class="modal seccess-modal" id="recovery-password-success-modal">
    <div class="modal-bg modal-exit"></div>
    <div class="modal-content">
        <div class="modal-body">
                <span class="close close-modal modal-exit" onclick="window.location = window.location.href.split('?')[0];">
                      <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7.00072 5.58672L11.9507 0.636719L13.3647 2.05072L8.41472 7.00072L13.3647 11.9507L11.9507 13.3647L7.00072 8.41472L2.05072 13.3647L0.636719 11.9507L5.58672 7.00072L0.636719 2.05072L2.05072 0.636719L7.00072 5.58672Z" fill="black"/>
                    </svg>
                </span>

            <svg class="modal__icon" width="40" height="41" viewBox="0 0 40 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M20 37.1678C10.795 37.1678 3.33334 29.7061 3.33334 20.5011C3.33334 11.2961 10.795 3.83447 20 3.83447C29.205 3.83447 36.6667 11.2961 36.6667 20.5011C36.6667 29.7061 29.205 37.1678 20 37.1678ZM20 33.8345C23.5362 33.8345 26.9276 32.4297 29.4281 29.9292C31.9286 27.4287 33.3333 24.0374 33.3333 20.5011C33.3333 16.9649 31.9286 13.5735 29.4281 11.073C26.9276 8.57256 23.5362 7.16781 20 7.16781C16.4638 7.16781 13.0724 8.57256 10.5719 11.073C8.07144 13.5735 6.66668 16.9649 6.66668 20.5011C6.66668 24.0374 8.07144 27.4287 10.5719 29.9292C13.0724 32.4297 16.4638 33.8345 20 33.8345V33.8345ZM11.6667 22.1678H15C15 23.4939 15.5268 24.7657 16.4645 25.7033C17.4022 26.641 18.6739 27.1678 20 27.1678C21.3261 27.1678 22.5979 26.641 23.5355 25.7033C24.4732 24.7657 25 23.4939 25 22.1678H28.3333C28.3333 24.3779 27.4554 26.4976 25.8926 28.0604C24.3298 29.6232 22.2101 30.5011 20 30.5011C17.7899 30.5011 15.6703 29.6232 14.1075 28.0604C12.5447 26.4976 11.6667 24.3779 11.6667 22.1678V22.1678ZM13.3333 18.8345C12.6703 18.8345 12.0344 18.5711 11.5656 18.1022C11.0967 17.6334 10.8333 16.9975 10.8333 16.3345C10.8333 15.6714 11.0967 15.0355 11.5656 14.5667C12.0344 14.0979 12.6703 13.8345 13.3333 13.8345C13.9964 13.8345 14.6323 14.0979 15.1011 14.5667C15.57 15.0355 15.8333 15.6714 15.8333 16.3345C15.8333 16.9975 15.57 17.6334 15.1011 18.1022C14.6323 18.5711 13.9964 18.8345 13.3333 18.8345ZM26.6667 18.8345C26.0036 18.8345 25.3678 18.5711 24.8989 18.1022C24.4301 17.6334 24.1667 16.9975 24.1667 16.3345C24.1667 15.6714 24.4301 15.0355 24.8989 14.5667C25.3678 14.0979 26.0036 13.8345 26.6667 13.8345C27.3297 13.8345 27.9656 14.0979 28.4344 14.5667C28.9033 15.0355 29.1667 15.6714 29.1667 16.3345C29.1667 16.9975 28.9033 17.6334 28.4344 18.1022C27.9656 18.5711 27.3297 18.8345 26.6667 18.8345Z" fill="black"/>
            </svg>
            <span class="modal__title mb-16">Success!</span>
            <p class="modal__desc">Your password has been successfully changed</p>
            <button type="submit" class="btn btn-yellow btn-yellow--big w-100 modal-exit" onclick="window.location = window.location.href.split('?')[0];">Ok</button>
        </div>
    </div>
</div>
    
    <script src="build/914.95fc2fe3.js" defer></script><script src="build/homepage.46ead804.js" defer></script>

    
        

    <link rel="stylesheet" href="build/footer.965131dc.css">

<script type="text/javascript">
    try {
        function successfullySignUp(provider = 'email') {
            try {
                window.fbca.CompleteRegistration()
            } catch (e) {
                setTimeout(() => {
                    try {
                        window.fbca.CompleteRegistration()
                    } catch (e) {
                        console.error(e);
                    }
                }, 100)
            }
        }

        window.abtData = JSON.parse('{"hk-processing-v1":"b","payment_mails_v1":"a","subs_reactivation_flow_v1":"b","ht-456-fb-v1":"a","ht-456-not-fb-v1":"a","sign-up-marketing-subscribe-v1":"b","ht-457-censored-upgrade-v1":"b","multi_content_episode_girl-next-door":"Original version"}')
        window.abtData.visitor_key_v2 = '1efd71cb-586e-6c24-a7c7-839539337942'
        console.table(window.abtData)
    } catch (e) {
        console.error(e);
    }
</script>








    <!--Library initialization-->
    <script type="text/javascript" src="https://js.wooxy.com/js/v2/661f7fdc027fb2ea45092c1e.js" charset="UTF-8"></script>
    <script type="text/javascript">
        let contact = new _wooxyContact('6413757');
        setTimeout(()=>{
            contact.ShowPushPrompt();
            console.log('ShowPushPrompt')
        },5000)
    </script>

<style>
    :root {
            --genre-romance-color: #ff80bd;
            --genre-detective-color: #a6075c;
            --genre-adventure-color: #80a3ea;
            --genre-business-color: #fff15c;
            --genre-thriller-color: #9cabc4;
            --genre-drama-color: #97c256;
            --genre-bl-color: #9ee7ff;
            --genre-mommy-color: #9beebf;
            --genre-in-law-color: #ffc68c;
            --genre-cheating-color: #ffff99;
            --genre-college-color: #9896ff;
            --genre-supernatural-color: #37a5b3;
            --genre-uncensored-color: #ff0000;
            --genre-milf-color: #cb6cc8;
            --genre-harem-color: #81d41c;
            --genre-new-color: #41ee2b;
        }
</style>

</html>
